/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.xml;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class StripDoctypeFilter {
    private int[] _buffer;
    private int _bufferLength;
    private boolean _documentStarted;
    private boolean _entityDeclaration;
    private final InputStream _inputStream;
    private final Reader _reader;

    public StripDoctypeFilter(InputStream inputStream) {
        this(inputStream, null);
    }

    public StripDoctypeFilter(Reader reader) {
        this(null, reader);
    }

    public int read() throws IOException {
        if (this._bufferLength > 0) {
            return this.readFromBuffer();
        }
        int c = this.readFromSource();
        if (this._documentStarted) {
            return c;
        }
        if (c == 60) {
            int[] buffer = new int[]{this.readFromSource(), this.readFromSource()};
            if (buffer[0] == 63) {
                this.setBuffer(buffer);
                return c;
            }
            if (buffer[0] == 33 && buffer[1] == 45) {
                this.setBuffer(buffer);
                return c;
            }
            if (buffer[0] == 33 && buffer[1] == 68) {
                while (true) {
                    int doctypeContent;
                    if ((doctypeContent = this.readFromSource()) == 91) {
                        this._entityDeclaration = true;
                        continue;
                    }
                    if (doctypeContent == 93) {
                        this._entityDeclaration = false;
                        continue;
                    }
                    if (doctypeContent == 62 && !this._entityDeclaration) break;
                }
                this._documentStarted = true;
                return this.readFromSource();
            }
            this.setBuffer(buffer);
            this._documentStarted = true;
        }
        return c;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this._documentStarted && length > this._bufferLength) {
            int bufferLength = this._bufferLength;
            for (int i = 0; i < bufferLength; ++i) {
                bytes[offset++] = (byte)(this.readFromBuffer() & 0xFF);
            }
            return this._inputStream.read(bytes, offset, length - bufferLength) + bufferLength;
        }
        int read = 0;
        for (read = 0; read < length; ++read) {
            int c = this.read();
            if (c == -1) {
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            bytes[offset + read] = (byte)(c & 0xFF);
        }
        return read;
    }

    public int read(char[] chars, int offset, int length) throws IOException {
        if (this._documentStarted && length > this._bufferLength) {
            int bufferLength = this._bufferLength;
            for (int i = 0; i < bufferLength; ++i) {
                chars[offset++] = (char)this.readFromBuffer();
            }
            return this._reader.read(chars, offset, length - bufferLength) + bufferLength;
        }
        int read = 0;
        for (read = 0; read < length; ++read) {
            int c = this.read();
            if (c == -1) {
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            chars[offset + read] = (char)c;
        }
        return read;
    }

    protected StripDoctypeFilter(InputStream inputStream, Reader reader) {
        this._inputStream = inputStream;
        this._reader = reader;
    }

    protected int readFromBuffer() {
        --this._bufferLength;
        return this._buffer[this._bufferLength];
    }

    protected int readFromSource() throws IOException {
        if (this._inputStream != null) {
            return this._inputStream.read();
        }
        if (this._reader != null) {
            return this._reader.read();
        }
        throw new IllegalStateException("No underlying source available");
    }

    protected void setBuffer(int[] buffer) {
        this._buffer = buffer;
        ArrayUtil.reverse((int[])this._buffer);
        this._bufferLength = this._buffer.length;
    }
}

