/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.NamedThreadLocal;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringHibernateThreadLocalUtil {
    private static final ThreadLocal<Map<Object, Object>> _resourcesThreadLocal;

    public static <T> T getResource(Object key) {
        ResourceHolder resourceHolder;
        Map<Object, Object> resources = _resourcesThreadLocal.get();
        if (resources == null) {
            return null;
        }
        Object resource = resources.get(key);
        if (resource instanceof ResourceHolder && (resourceHolder = (ResourceHolder)resource).isVoid()) {
            resources.remove(key);
            if (resources.isEmpty()) {
                _resourcesThreadLocal.remove();
            }
            return null;
        }
        return (T)resource;
    }

    public static <T> T setResource(Object key, Object resource) {
        ResourceHolder resourceHolder;
        Map<Object, Object> resources = _resourcesThreadLocal.get();
        Object oldResource = null;
        if (resource == null) {
            if (resources == null) {
                return null;
            }
            oldResource = resources.remove(key);
            if (resources.isEmpty()) {
                _resourcesThreadLocal.remove();
            }
        } else {
            if (resources == null) {
                resources = new HashMap<Object, Object>();
                _resourcesThreadLocal.set(resources);
            }
            oldResource = resources.put(key, resource);
        }
        if (oldResource instanceof ResourceHolder && (resourceHolder = (ResourceHolder)oldResource).isVoid()) {
            oldResource = null;
        }
        return (T)oldResource;
    }

    static {
        try {
            Field nameField = ReflectionUtil.getDeclaredField(NamedThreadLocal.class, (String)"name");
            ThreadLocal resourcesThreadLocal = null;
            for (Field field : ReflectionUtil.getDeclaredFields(TransactionSynchronizationManager.class)) {
                if (!Modifier.isStatic(field.getModifiers()) || !ThreadLocal.class.isAssignableFrom(field.getType())) continue;
                ThreadLocal threadLocal = (ThreadLocal)field.get(null);
                Object value = threadLocal.get();
                threadLocal = threadLocal instanceof NamedThreadLocal ? new CentralizedThreadLocal((String)nameField.get(threadLocal), () -> null, false) : new CentralizedThreadLocal(false);
                if (value != null) {
                    threadLocal.set(value);
                }
                field.set(null, threadLocal);
                String name = field.getName();
                if (!name.equals("resources")) continue;
                resourcesThreadLocal = threadLocal;
            }
            if (resourcesThreadLocal == null) {
                throw new ExceptionInInitializerError("Unable to locate \"resources\" thread local field from " + TransactionSynchronizationManager.class);
            }
            _resourcesThreadLocal = resourcesThreadLocal;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

