/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class DefaultTransactionExecutor
implements TransactionExecutor,
TransactionHandler {
    @Override
    public void commit(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        this._commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter, null);
    }

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatusAdapter transactionStatusAdapter = this.start(platformTransactionManager, transactionAttributeAdapter);
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.rollback(platformTransactionManager, throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this.commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter);
        return returnValue;
    }

    @Override
    public void rollback(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        if (transactionAttributeAdapter.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
            }
            catch (Throwable t) {
                t.addSuppressed(throwable);
                throw t;
            }
            finally {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, (Throwable)throwable);
            }
        } else {
            this._commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter, throwable);
        }
        throw throwable;
    }

    @Override
    public TransactionStatusAdapter start(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter) {
        TransactionStatusAdapter transactionStatusAdapter = new TransactionStatusAdapter(platformTransactionManager, platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
        TransactionLifecycleManager.fireTransactionCreatedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
        return transactionStatusAdapter;
    }

    private void _commit(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter, Throwable applicationThrowable) {
        Throwable throwable = null;
        try {
            platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (Throwable t) {
            if (applicationThrowable != null) {
                t.addSuppressed(applicationThrowable);
            }
            throwable = t;
            throw t;
        }
        finally {
            if (throwable != null) {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, (Throwable)throwable);
            } else {
                TransactionLifecycleManager.fireTransactionCommittedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
            }
        }
    }
}

