/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.tools.deploy.DeploymentHandler;
import com.liferay.portal.tools.deploy.StartProgressListener;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentProgressListener
implements ProgressListener {
    private static final Log _log = LogFactoryUtil.getLog(DeploymentProgressListener.class);
    private final DeploymentHandler _deploymentHandler;
    private final DeploymentManager _deploymentManager;
    private final String _warContext;

    public DeploymentProgressListener(DeploymentHandler deploymentHandler, String warContext) {
        this._deploymentHandler = deploymentHandler;
        this._warContext = warContext;
        this._deploymentManager = this._deploymentHandler.getDeploymentManager();
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        DeploymentStatus deploymentStatus = progressEvent.getDeploymentStatus();
        if (_log.isInfoEnabled()) {
            _log.info((Object)deploymentStatus.getMessage());
        }
        if (deploymentStatus.isCompleted()) {
            try {
                Object[] targetModuleIDs = this._deploymentManager.getNonRunningModules(ModuleType.WAR, this._deploymentManager.getTargets());
                if (ArrayUtil.isNotEmpty((Object[])targetModuleIDs)) {
                    for (Object targetModuleID : targetModuleIDs) {
                        if (!this._warContext.equals(targetModuleID.getModuleID())) continue;
                        ProgressObject startProgress = this._deploymentManager.start(new TargetModuleID[]{targetModuleID});
                        startProgress.addProgressListener((ProgressListener)new StartProgressListener(this._deploymentHandler));
                        this._deploymentHandler.setError(false);
                        this._deploymentHandler.setStarted(true);
                    }
                }
                for (Object targetModuleID : targetModuleIDs = this._deploymentManager.getAvailableModules(ModuleType.WAR, this._deploymentManager.getTargets())) {
                    if (!this._warContext.equals(targetModuleID.getModuleID())) continue;
                    ProgressObject startProgress = this._deploymentManager.start(new TargetModuleID[]{targetModuleID});
                    startProgress.addProgressListener((ProgressListener)new StartProgressListener(this._deploymentHandler));
                    this._deploymentHandler.setError(false);
                    this._deploymentHandler.setStarted(true);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                this._deploymentHandler.setError(true);
                this._deploymentHandler.setStarted(false);
            }
        } else if (deploymentStatus.isFailed()) {
            this._deploymentHandler.setError(true);
            this._deploymentHandler.setStarted(false);
        }
    }
}

