/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChainingCheck
extends BaseCheck {
    private static final String _MSG_AVOID_CHAINING = "chaining.avoid";
    private static final String _MSG_AVOID_TOO_MANY_CONCAT = "concat.avoid.too.many";
    private static final String _MSG_INCORRECT_STYLING = "styling.incorrect";
    private String[] _allowedClassNames = new String[0];
    private String[] _allowedMethodNames = new String[0];
    private String[] _allowedVariableTypeNames = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void setAllowedClassNames(String allowedClassNames) {
        this._allowedClassNames = ArrayUtil.append(this._allowedClassNames, StringUtil.split(allowedClassNames));
    }

    public void setAllowedMethodNames(String allowedMethodNames) {
        this._allowedMethodNames = ArrayUtil.append(this._allowedMethodNames, StringUtil.split(allowedMethodNames));
    }

    public void setAllowedVariableTypeNames(String allowedVariableTypeNames) {
        this._allowedVariableTypeNames = ArrayUtil.append(this._allowedVariableTypeNames, StringUtil.split(allowedVariableTypeNames));
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            List<String> chain;
            int chainSize;
            List<DetailAST> childMethodCallASTList;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST != null && !(childMethodCallASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 27)).isEmpty() || this._isInsideAnonymousClassVariableDefinition(methodCallAST) || (chainSize = (chain = this._getChain(methodCallAST)).size()) == 1) continue;
            if (chainSize == 2) {
                FileContents fileContents;
                String fileName;
                if (dotAST == null) continue;
                this._checkMethodName(chain, "getClass", methodCallAST, detailAST);
                String name1 = chain.get(0);
                if ((name1.equals("getParamValue") || name1.equals("getValue")) && DetailASTUtil.hasParentWithTokenType(detailAST, 154)) continue;
                String name2 = chain.get(1);
                if (name1.equals("concat") || name2.equals("concat") || (fileName = StringUtil.replace((fileContents = this.getFileContents()).getFileName(), '\\', '/')).contains("/test/") || fileName.contains("/testIntegration/")) continue;
            }
            if (this._isAllowedChainingMethodCall(detailAST, methodCallAST, chain)) {
                if (chainSize <= 2) continue;
                this._checkStyling(detailAST, methodCallAST);
                continue;
            }
            int concatsCount = Collections.frequency(chain, "concat");
            if (concatsCount > 2) {
                this.log(methodCallAST.getLineNo(), _MSG_AVOID_TOO_MANY_CONCAT, new Object[0]);
                continue;
            }
            if (chainSize == 3 && concatsCount == 2) continue;
            this.log(methodCallAST.getLineNo(), _MSG_AVOID_CHAINING, new Object[]{DetailASTUtil.getMethodName(methodCallAST)});
        }
    }

    private void _checkMethodName(List<String> chainedMethodNames, String methodName, DetailAST methodCallAST, DetailAST detailAST) {
        String firstMethodName = chainedMethodNames.get(0);
        if (firstMethodName.equals(methodName) && !this._isInsideConstructorThisCall(methodCallAST, detailAST) && !DetailASTUtil.hasParentWithTokenType(methodCallAST, 42)) {
            this.log(methodCallAST.getLineNo(), _MSG_AVOID_CHAINING, new Object[]{methodName});
        }
    }

    private void _checkStyling(DetailAST detailAST, DetailAST methodCallAST) {
        if (this._isInsideConstructorThisCall(methodCallAST, detailAST) || DetailASTUtil.hasParentWithTokenType(methodCallAST, 42)) {
            return;
        }
        for (int i = DetailASTUtil.getStartLine(methodCallAST) + 1; i <= DetailASTUtil.getEndLine(methodCallAST); ++i) {
            String line = StringUtil.trim(this.getLine(i - 1));
            if (!line.startsWith(").")) continue;
            return;
        }
        this.log(methodCallAST.getLineNo(), _MSG_INCORRECT_STYLING, new Object[]{DetailASTUtil.getMethodName(methodCallAST)});
    }

    private List<String> _getChain(DetailAST methodCallAST) {
        ArrayList<String> chain = new ArrayList<String>();
        chain.add(DetailASTUtil.getMethodName(methodCallAST));
        DetailAST parentAST;
        while ((parentAST = methodCallAST.getParent()).getType() == 59) {
            DetailAST grandParentAST = parentAST.getParent();
            if (grandParentAST.getType() != 27) {
                DetailAST siblingAST = methodCallAST.getNextSibling();
                if (siblingAST.getType() == 58) {
                    chain.add(siblingAST.getText());
                }
                return chain;
            }
            methodCallAST = grandParentAST;
            chain.add(DetailASTUtil.getMethodName(methodCallAST));
        }
        return chain;
    }

    private DetailAST _getOuterMethodCallAST(DetailAST detailAST) {
        DetailAST parentAST;
        while (true) {
            if (detailAST.getType() != 59 && detailAST.getType() != 27) {
                return null;
            }
            parentAST = detailAST.getParent();
            if (detailAST.getType() == 27 && parentAST.getType() != 59) break;
            detailAST = parentAST;
        }
        while (true) {
            if ((parentAST = detailAST.getParent()) == null) {
                return null;
            }
            if (parentAST.getType() == 27) break;
            detailAST = parentAST;
        }
        detailAST = parentAST;
        while (true) {
            DetailAST childAST = detailAST.getFirstChild();
            if (detailAST.getType() != 59 && detailAST.getType() != 27) {
                return null;
            }
            if (detailAST.getType() == 59 && childAST.getType() != 27) {
                return detailAST.getParent();
            }
            detailAST = childAST;
        }
    }

    private boolean _isAllowedChainingMethodCall(DetailAST detailAST, DetailAST methodCallAST, List<String> chainedMethodNames) {
        DetailAST outerMethodCallAST;
        if (this._isInsideConstructorThisCall(methodCallAST, detailAST) || DetailASTUtil.hasParentWithTokenType(methodCallAST, 42)) {
            return true;
        }
        for (String allowedMethodName : this._allowedMethodNames) {
            if (!chainedMethodNames.contains(allowedMethodName)) continue;
            return true;
        }
        DetailAST dotAST = methodCallAST.findFirstToken(59);
        if (dotAST == null) {
            FileContents fileContents = this.getFileContents();
            FileText fileText = fileContents.getText();
            String content = (String)fileText.getFullText();
            return content.contains("extends PowerMockito");
        }
        DetailAST nameAST = null;
        DetailAST firstChild = dotAST.getFirstChild();
        nameAST = firstChild.getType() == 136 ? firstChild.findFirstToken(58) : dotAST.findFirstToken(58);
        if (nameAST != null) {
            String classOrVariableName = nameAST.getText();
            if (this._isLambdaVariable(methodCallAST, classOrVariableName)) {
                return true;
            }
            for (String allowedClassName : this._allowedClassNames) {
                if (!classOrVariableName.matches(allowedClassName)) continue;
                return true;
            }
            String variableTypeName = DetailASTUtil.getVariableTypeName(methodCallAST, classOrVariableName);
            if (Validator.isNotNull(variableTypeName)) {
                for (String allowedVariableTypeName : this._allowedVariableTypeNames) {
                    if (!variableTypeName.matches(allowedVariableTypeName)) continue;
                    return true;
                }
            }
        }
        if ((outerMethodCallAST = this._getOuterMethodCallAST(methodCallAST)) != null) {
            return this._isAllowedChainingMethodCall(detailAST, outerMethodCallAST, this._getChain(outerMethodCallAST));
        }
        return false;
    }

    private boolean _isInsideAnonymousClassVariableDefinition(DetailAST detailAST) {
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() == 8 || parentAST.getType() == 9) {
                return false;
            }
            if (parentAST.getType() != 10) continue;
            return (parentAST = parentAST.getParent()).getType() == 6;
        }
        return false;
    }

    private boolean _isInsideConstructorThisCall(DetailAST methodCallAST, DetailAST detailAST) {
        if (detailAST.getType() != 8) {
            return false;
        }
        for (DetailAST parentAST = methodCallAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            String parentASTText = parentAST.getText();
            if (parentAST.getType() != 43 || !parentASTText.equals("this")) continue;
            return true;
        }
        return false;
    }

    private boolean _isLambdaVariable(DetailAST methodCallAST, String variableName) {
        for (DetailAST parentAST = methodCallAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() != 181) {
                continue;
            }
            DetailAST nameAST = parentAST.findFirstToken(58);
            return nameAST != null && variableName.equals(nameAST.getText());
        }
        return false;
    }
}

