/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;

public class JSONNamingCheck
extends BaseCheck {
    private static final String _MSG_RENAME_VARIABLE = "variable.rename";
    private static final String _MSG_RESERVED_VARIABLE_NAME = "variable.name.reserved";
    private static final String _TOKEN_TYPE_NAME_METHOD = "Method";
    private static final String _TOKEN_TYPE_NAME_PARAMETER = "Parameter";
    private static final String _TOKEN_TYPE_NAME_VARIABLE = "Variable";
    private static final String[] _TOKEN_TYPE_NAMES = new String[]{"Method", "Parameter", "Variable"};

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 9 && AnnotationUtility.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        String typeName = DetailASTUtil.getTypeName(detailAST);
        if (typeName.equals("boolean") || typeName.equals("void")) {
            return;
        }
        String name = this._getName(detailAST);
        String tokenTypeName = this._getTokenTypeName(detailAST);
        this._checkName(name, typeName, tokenTypeName, "String", "JSON", "Json", detailAST.getLineNo(), _TOKEN_TYPE_NAMES);
        this._checkName(name, typeName, tokenTypeName, "JSONArray", "JSONArray", "JsonArray", detailAST.getLineNo(), _TOKEN_TYPE_NAMES);
        this._checkName(name, typeName, tokenTypeName, "JSONObject", "JSONObject", "JsonObject", detailAST.getLineNo(), _TOKEN_TYPE_NAMES);
        this._checkName(name, tokenTypeName, "JSON", "JSONString", detailAST.getLineNo(), new String[]{_TOKEN_TYPE_NAME_VARIABLE});
        this._checkName(name, tokenTypeName, "JSON", "JsonString", detailAST.getLineNo(), new String[]{_TOKEN_TYPE_NAME_VARIABLE});
    }

    private void _checkName(String name, String tokenTypeName, String validNameEnding, String incorrectNameEnding, int lineNo, String[] checkTokenTypeNames) {
        String lowerCaseName = StringUtil.toLowerCase(name);
        if (!lowerCaseName.endsWith(StringUtil.toLowerCase(incorrectNameEnding))) {
            return;
        }
        if (name.endsWith(incorrectNameEnding) && ArrayUtil.contains(checkTokenTypeNames, tokenTypeName)) {
            this.log(lineNo, _MSG_RENAME_VARIABLE, new Object[]{StringUtil.toLowerCase(tokenTypeName), name, StringUtil.replaceLast(name, incorrectNameEnding, validNameEnding)});
        }
    }

    private void _checkName(String name, String typeName, String tokenTypeName, String type, String reservedNameEnding, String incorrectNameEnding, int lineNo, String[] checkTokenTypeNames) {
        String lowerCaseName = StringUtil.toLowerCase(name);
        if (!lowerCaseName.endsWith(StringUtil.toLowerCase(incorrectNameEnding))) {
            return;
        }
        if (!typeName.equals(type) && !typeName.endsWith("." + type)) {
            String lowerCaseTypeName = StringUtil.toLowerCase(typeName);
            if (!lowerCaseTypeName.endsWith(StringUtil.toLowerCase(type))) {
                this.log(lineNo, _MSG_RESERVED_VARIABLE_NAME, new Object[]{tokenTypeName, reservedNameEnding, type});
            }
            return;
        }
        this._checkName(name, tokenTypeName, reservedNameEnding, incorrectNameEnding, lineNo, checkTokenTypeNames);
    }

    private String _getName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        return nameAST.getText();
    }

    private String _getTokenTypeName(DetailAST detailAST) {
        if (detailAST.getType() == 9) {
            return _TOKEN_TYPE_NAME_METHOD;
        }
        if (detailAST.getType() == 21) {
            return _TOKEN_TYPE_NAME_PARAMETER;
        }
        return _TOKEN_TYPE_NAME_VARIABLE;
    }
}

