/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PropertiesLanguageKeysCheck
extends BaseFileCheck {
    private final List<String> _allowedLanguageKeys = new ArrayList<String>();

    public void setAllowedLanguageKeys(String allowedLanguageKeys) {
        Collections.addAll(this._allowedLanguageKeys, StringUtil.split(allowedLanguageKeys));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String value;
                String key;
                String[] array = line.split("=", 2);
                if (array.length < 2 || this._isAllowedLanguageKey(key = array[0]) || !(value = array[1]).matches("(?s).*<([a-zA-Z0-9]+)[^>]*>.*?<\\/\\1>.*")) continue;
                this.addMessage(fileName, "Remove HTML markup for '" + key + "'", "language_keys.markdown", this.getLineCount(content, content.indexOf(line)));
            }
        }
        return content;
    }

    private boolean _isAllowedLanguageKey(String key) {
        String s = key.replaceAll("[^\\w.-]", "");
        for (String allowedLanguageKey : this._allowedLanguageKeys) {
            if (!s.equals(allowedLanguageKey)) continue;
            return true;
        }
        return false;
    }
}

