/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.google.common.collect.ImmutableMap;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.InputSource;

public class CheckstyleUtil {
    public static final int BATCH_SIZE = 1000;

    public static String getCheckName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static List<String> getCheckNames(Configuration configuration) {
        ArrayList<String> checkNames = new ArrayList<String>();
        String name = configuration.getName();
        if (name.startsWith("com.liferay.")) {
            int pos = name.lastIndexOf(46);
            checkNames.add(name.substring(pos + 1));
        }
        for (Configuration childConfiguration : configuration.getChildren()) {
            checkNames.addAll(CheckstyleUtil.getCheckNames(childConfiguration));
        }
        return checkNames;
    }

    public static Configuration getConfiguration(String configurationFileName, Map<String, Properties> propertiesMap, SourceFormatterArgs sourceFormatterArgs) throws Exception {
        ClassLoader classLoader = CheckstyleUtil.class.getClassLoader();
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream(configurationFileName)), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
        configuration = CheckstyleUtil._addAttribute(configuration, "baseDirName", sourceFormatterArgs.getBaseDirName(), "com.liferay.source.formatter.checkstyle.checks.GetterMethodCallCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "maxLineLength", String.valueOf(sourceFormatterArgs.getMaxLineLength()), "com.liferay.source.formatter.checkstyle.checks.AppendCheck", "com.liferay.source.formatter.checkstyle.checks.ConcatCheck", "com.liferay.source.formatter.checkstyle.checks.PlusStatementCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "portalBranchName", SourceFormatterUtil.getPropertyValue("git.liferay.portal.branch", propertiesMap), "com.liferay.source.formatter.checkstyle.checks.GetterMethodCallCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "runOutsidePortalExcludes", SourceFormatterUtil.getPropertyValue("run.outside.portal.excludes", propertiesMap), "com.liferay.source.formatter.checkstyle.checks.ParsePrimitiveTypeCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "showDebugInformation", String.valueOf(sourceFormatterArgs.isShowDebugInformation()), "com.liferay.*");
        configuration = CheckstyleUtil._addPropertiesAttributes(configuration, propertiesMap);
        if (sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.CHECKSTYLE, CheckstyleUtil.getCheckNames(configuration));
        }
        return configuration;
    }

    private static Configuration _addAttribute(Configuration configuration, String key, String value, String ... regexChecks) {
        Configuration[] checkConfigurations = CheckstyleUtil._getCheckConfigurations(configuration);
        if (checkConfigurations == null) {
            return configuration;
        }
        for (Configuration checkConfiguration : checkConfigurations) {
            if (!(checkConfiguration instanceof DefaultConfiguration)) continue;
            String name = checkConfiguration.getName();
            for (String regexCheck : regexChecks) {
                if (!name.matches(regexCheck)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)checkConfiguration;
                defaultChildConfiguration.addAttribute(key, value);
            }
        }
        return configuration;
    }

    private static Configuration _addPropertiesAttributes(Configuration configuration, Map<String, Properties> propertiesMap) throws CheckstyleException {
        Configuration[] checkConfigurations = CheckstyleUtil._getCheckConfigurations(configuration);
        if (checkConfigurations == null) {
            return configuration;
        }
        for (Configuration checkConfiguration : checkConfigurations) {
            if (!(checkConfiguration instanceof DefaultConfiguration)) continue;
            String checkName = CheckstyleUtil.getCheckName(checkConfiguration.getName());
            List<String> attributeNames = SourceFormatterUtil.getAttributeNames(CheckType.CHECKSTYLE, checkName, propertiesMap);
            for (String attributeName : attributeNames) {
                String value = SourceFormatterUtil.getPropertyValue(attributeName, CheckType.CHECKSTYLE, checkName, propertiesMap);
                if (Validator.isNull(value)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)checkConfiguration;
                if (Validator.isBoolean(value) || Validator.isNumber(value)) {
                    configuration = CheckstyleUtil._overrideAttributeValue(configuration, defaultChildConfiguration, attributeName, value);
                    continue;
                }
                defaultChildConfiguration.addAttribute(attributeName, value);
            }
        }
        return configuration;
    }

    private static Configuration[] _getCheckConfigurations(Configuration configuration) {
        DefaultConfiguration treeWalkerConfiguration = CheckstyleUtil._getChildConfiguration(configuration, "TreeWalker");
        if (treeWalkerConfiguration == null) {
            return null;
        }
        return treeWalkerConfiguration.getChildren();
    }

    private static DefaultConfiguration _getChildConfiguration(Configuration configuration, String name) {
        if (!(configuration instanceof DefaultConfiguration)) {
            return null;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)configuration;
        for (Configuration childConfiguration : defaultConfiguration.getChildren()) {
            String configurationName = childConfiguration.getName();
            if (!configurationName.equals(name) || !(childConfiguration instanceof DefaultConfiguration)) continue;
            return (DefaultConfiguration)childConfiguration;
        }
        return null;
    }

    private static Configuration _overrideAttributeValue(Configuration configuration, DefaultConfiguration defaultChildConfiguration, String attributeName, String value) throws CheckstyleException {
        DefaultConfiguration treeWalkerConfiguration = CheckstyleUtil._getChildConfiguration(configuration, "TreeWalker");
        DefaultConfiguration copyConfiguration = new DefaultConfiguration(defaultChildConfiguration.getName());
        ImmutableMap messages = defaultChildConfiguration.getMessages();
        for (Map.Entry entry : messages.entrySet()) {
            copyConfiguration.addMessage((String)entry.getKey(), (String)entry.getValue());
        }
        for (String name : defaultChildConfiguration.getAttributeNames()) {
            if (name.equals(attributeName)) {
                copyConfiguration.addAttribute(name, value);
                continue;
            }
            copyConfiguration.addAttribute(name, defaultChildConfiguration.getAttribute(name));
        }
        treeWalkerConfiguration.removeChild((Configuration)defaultChildConfiguration);
        treeWalkerConfiguration.addChild((Configuration)copyConfiguration);
        return configuration;
    }
}

