/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaPackagePathCheck
extends BaseFileCheck {
    private final List<String> _allowedInternalPackageDirNames = new ArrayList<String>();
    private final Pattern _internalPackagePattern = Pattern.compile("\\.(impl|internal)(\\.|\\Z)");

    public void setAllowedInternalPackageDirNames(String allowedInternalPackageDirNames) {
        Collections.addAll(this._allowedInternalPackageDirNames, StringUtil.split(allowedInternalPackageDirNames));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String packageName = JavaSourceUtil.getPackageName(content);
        if (Validator.isNull(packageName)) {
            this.addMessage(fileName, "Missing package");
            return content;
        }
        this._checkPackageName(fileName, absolutePath, packageName);
        if (this.isModulesFile(absolutePath) && !this.isModulesApp(absolutePath, true)) {
            this._checkModulePackageName(fileName, packageName);
        }
        return content;
    }

    private void _checkModulePackageName(String fileName, String packageName) throws Exception {
        if (!packageName.startsWith("com.liferay")) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        if (!bundleSymbolicName.startsWith("com.liferay")) {
            return;
        }
        if (packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|service|test)$", ""))) {
            return;
        }
        if (!packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.impl$", ".internal"))) {
            this.addMessage(fileName, "Package should follow Bundle-SymbolicName specified in " + bndSettings.getFileName(), "package.markdown");
        }
    }

    private void _checkPackageName(String fileName, String absolutePath, String packageName) {
        Matcher matcher;
        int pos = fileName.lastIndexOf(47);
        String filePath = StringUtil.replace(fileName.substring(0, pos), '/', '.');
        if (!filePath.endsWith(packageName)) {
            this.addMessage(fileName, "The declared package '" + packageName + "' does not match the expected package", "package.markdown");
            return;
        }
        if (packageName.matches(".*\\.internal\\.([\\w.]+\\.)?impl")) {
            this.addMessage(fileName, "Do not use 'impl' inside 'internal'", "package.markdown");
        }
        for (String allowedInternalPackageDirName : this._allowedInternalPackageDirNames) {
            if (!absolutePath.contains(allowedInternalPackageDirName)) continue;
            return;
        }
        if (absolutePath.contains("-api/src/") && (matcher = this._internalPackagePattern.matcher(packageName)).find()) {
            this.addMessage(fileName, "Do not use '" + matcher.group(1) + "' package in API module", "package.markdown");
        }
    }
}

