/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStringBundlerInitialCapacityCheck
extends BaseJavaTermCheck {
    private final Pattern _loopPattern = Pattern.compile("\t(do \\{|(for|while) \\()");
    private final Pattern _stringBundlerPattern = Pattern.compile("\n(\t+)(StringBundler )?(\\w+) = new StringBundler(\\(([0-9]+)?)\\);\n");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        return this._fixInitialCapacity(javaTerm.getContent());
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private int _addCountForStatements(int count, String s, String varName, String start, String nextStatementString, int level) {
        if (count == -1) {
            return count;
        }
        int x = -1;
        while ((x = s.indexOf(start, x + 1)) != -1) {
            if (this.getLevel(s.substring(0, x), "{", "}") != level) continue;
            List<String> parts = this._getStatementParts(s.substring(x), nextStatementString);
            int maxCount = 0;
            for (String part : parts) {
                if (part.contains(varName + ".append(") && part.contains("return")) {
                    return -1;
                }
                int partCount = this._getCount(part, varName, 1);
                if (partCount <= maxCount) continue;
                maxCount = partCount;
            }
            count += maxCount;
        }
        return count;
    }

    private String _fixInitialCapacity(String content) {
        Matcher matcher = this._stringBundlerPattern.matcher(content);
        while (matcher.find()) {
            int sbInitialCapacity;
            int count;
            int x;
            String line;
            String tabs = matcher.group(1);
            String varName = matcher.group(3);
            if (matcher.group(2) == null && !(line = this.getLine(content, this.getLineCount(content, x = content.lastIndexOf("StringBundler " + varName, matcher.start())))).startsWith(tabs) || (x = content.indexOf("\n" + tabs.substring(1) + "}", matcher.end())) == -1) continue;
            String s = content.substring(matcher.end(), x);
            x = s.indexOf("\t" + varName + " = new StringBundler");
            if (x != -1) {
                s = s.substring(0, x);
            }
            if (this._hasAppendCallInsideLoop(s, varName) || s.matches("(?s).*\\W" + varName + "([,)]|\\.index\\().*") || (count = this._getCount(s, varName, 0)) == -1 || (sbInitialCapacity = GetterUtil.getInteger(matcher.group(5))) <= count && (sbInitialCapacity == count || s.contains(varName + ".setIndex"))) continue;
            return StringUtil.replaceFirst(content, matcher.group(4), "(" + String.valueOf(count), matcher.start());
        }
        return content;
    }

    private int _getCount(String s, String varName, int level) {
        int count = 0;
        int x = -1;
        while ((x = s.indexOf(varName + ".append(", x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(s, x) || this.getLevel(s.substring(0, x), "{", "}") != level) continue;
            ++count;
        }
        count = this._addCountForStatements(count, s, varName, "\tif (", "else ", level);
        count = this._addCountForStatements(count, s, varName, "\ttry {", "catch ", level);
        count = this._addCountForStatements(count, s, varName, " -> {\n", null, level);
        return count;
    }

    private List<String> _getStatementParts(String s, String nextStatementString) {
        ArrayList<String> parts = new ArrayList<String>();
        int x = -1;
        while ((x = s.indexOf("}", x + 1)) != -1) {
            String part;
            if (ToolsUtil.isInsideQuotes(s, x) || this.getLevel(part = s.substring(0, x + 1), "{", "}") != 0) continue;
            parts.add(part);
            s = StringUtil.trim(s.substring(x + 1));
            if (nextStatementString == null || !s.startsWith(nextStatementString)) {
                return parts;
            }
            x = -1;
        }
        return parts;
    }

    private boolean _hasAppendCallInsideLoop(String s, String varName) {
        Matcher matcher = this._loopPattern.matcher(s);
        while (matcher.find()) {
            String insideLoop;
            int x;
            int y = x = matcher.start();
            do {
                if ((y = s.indexOf("}", y + 1)) != -1) continue;
                return true;
            } while (this.getLevel(insideLoop = s.substring(x, y + 1), "{", "}") != 0);
            if (!insideLoop.contains(varName + ".append(")) continue;
            return true;
        }
        return false;
    }
}

