/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLPortletFileCheck
extends BaseFileCheck {
    private static final String _NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES = "numerical.portlet.name.element.excludes";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("/liferay-portlet.xml") || (this.isPortalSource() || this.isSubrepository()) && fileName.endsWith("/portlet-custom.xml") || !this.isPortalSource() && !this.isSubrepository() && fileName.endsWith("/portlet.xml")) {
            this._checkPortletXML(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkPortletXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        boolean checkNumericalPortletNameElement = !this.isExcludedPath(_NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES, absolutePath);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            Element portletNameElement;
            String portletNameText;
            if (!checkNumericalPortletNameElement || Validator.isNumber(portletNameText = (portletNameElement = portletElement.element("portlet-name")).getText())) continue;
            this.addMessage(fileName, "Nonstandard portlet-name element '" + portletNameText + "'");
        }
    }
}

