/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ConstructorMissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE = "empty.line.missing";

    public int[] getDefaultTokens() {
        return new int[]{8};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST statementsAST = detailAST.findFirstToken(7);
        if (statementsAST == null) {
            return;
        }
        List<String> parameterNames = DetailASTUtil.getParameterNames(detailAST);
        if (parameterNames.isEmpty()) {
            return;
        }
        DetailAST nextExpressionAST = statementsAST.getFirstChild();
        if (!this._isExpressionAssignsParameter(nextExpressionAST, parameterNames)) {
            return;
        }
        int endLine = DetailASTUtil.getEndLine(nextExpressionAST);
        while (true) {
            nextExpressionAST = nextExpressionAST.getNextSibling();
            if ((nextExpressionAST = nextExpressionAST.getNextSibling()) != null && nextExpressionAST.getType() == 73) {
                return;
            }
            if (!this._isExpressionAssignsParameter(nextExpressionAST, parameterNames)) {
                int startLine = DetailASTUtil.getStartLine(nextExpressionAST);
                if (endLine + 1 != startLine) {
                    return;
                }
                this.log(startLine, _MSG_MISSING_EMPTY_LINE, new Object[]{startLine});
                return;
            }
            endLine = DetailASTUtil.getEndLine(nextExpressionAST);
        }
    }

    private boolean _isExpressionAssignsParameter(DetailAST expressionAST, List<String> parameters) {
        if (expressionAST == null || expressionAST.getType() != 28) {
            return false;
        }
        DetailAST childAST = expressionAST.getFirstChild();
        if (childAST.getType() != 80) {
            return false;
        }
        if (childAST.getChildCount() != 2) {
            return false;
        }
        DetailAST firstChildAST = childAST.getFirstChild();
        DetailAST lastChildAST = childAST.getLastChild();
        if (firstChildAST.getType() != 58 || lastChildAST.getType() != 58) {
            return false;
        }
        if (!parameters.contains(lastChildAST.getText())) {
            return false;
        }
        DetailAST nextSiblingAST = expressionAST.getNextSibling();
        return nextSiblingAST.getType() == 45;
    }
}

