/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeprecatedMethodCallsCheck
extends BaseCheck {
    private static final FileSystem _FILE_SYSTEM = FileSystems.getDefault();
    private static final String _MSG_DEPRECATED_METHOD_CALL = "method.call.deprecated";
    private static final PathMatcher _PATH_MATCHER = _FILE_SYSTEM.getPathMatcher("glob:**/bnd.bnd");
    private static final PathMatcher[] _PATH_MATCHERS = new PathMatcher[]{_FILE_SYSTEM.getPathMatcher("glob:**/.git/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.gradle/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.idea/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.m2/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.settings/**"), _FILE_SYSTEM.getPathMatcher("glob:**/bin/**"), _FILE_SYSTEM.getPathMatcher("glob:**/build/**"), _FILE_SYSTEM.getPathMatcher("glob:**/classes/**"), _FILE_SYSTEM.getPathMatcher("glob:**/sql/**"), _FILE_SYSTEM.getPathMatcher("glob:**/src/**"), _FILE_SYSTEM.getPathMatcher("glob:**/test-classes/**"), _FILE_SYSTEM.getPathMatcher("glob:**/test-coverage/**"), _FILE_SYSTEM.getPathMatcher("glob:**/test-results/**"), _FILE_SYSTEM.getPathMatcher("glob:**/tmp/**")};
    private static final String _TYPE_UNKNOWN = "unknown";
    private Map<String, String> _bundleSymbolicNamesMap;
    private final Map<String, Tuple> _javaMethodsTupleMap = new HashMap<String, Tuple>();
    private String _rootDirName;

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        if (AnnotationUtility.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String className = nameAST.getText();
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        String absolutePath = SourceUtil.getAbsolutePath(fileName);
        int x = absolutePath.lastIndexOf("/");
        String directoryPath = absolutePath.substring(0, x + 1);
        List<String> importNames = DetailASTUtil.getImportNames(detailAST);
        String packageName = this._getPackageName(detailAST);
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        block0: for (DetailAST methodCallAST : methodCallASTList) {
            if (this._hasDeprecatedParent(methodCallAST)) continue;
            String methodName = DetailASTUtil.getMethodName(methodCallAST);
            Tuple javaMethodsTuple = this._getJavaMethodsTuple(methodCallAST, className, packageName, importNames, directoryPath);
            if (javaMethodsTuple == null) continue;
            boolean inheritsThirdParty = (Boolean)javaMethodsTuple.getObject(1);
            List<String> parameterTypeNames = this._getParameterTypeNames(methodCallAST);
            if (inheritsThirdParty && parameterTypeNames.contains(_TYPE_UNKNOWN)) continue;
            boolean deprecated = false;
            List javaMethods = (List)javaMethodsTuple.getObject(0);
            block1: for (JavaMethod javaMethod : javaMethods) {
                List<JavaParameter> parameters = this._getParameters(javaMethod);
                if (!methodName.equals(javaMethod.getName()) || parameterTypeNames.size() != parameters.size()) continue;
                if (!javaMethod.hasAnnotation("Deprecated")) continue block0;
                for (int i = 0; i < parameterTypeNames.size(); ++i) {
                    String parameterTypeName2;
                    JavaParameter parameter = parameters.get(i);
                    String parameterTypeName1 = parameter.getParameterType();
                    int pos = parameterTypeName1.indexOf("<");
                    if (pos != -1) {
                        parameterTypeName1 = parameterTypeName1.substring(0, pos);
                    }
                    if (!parameterTypeName1.equals(parameterTypeName2 = parameterTypeNames.get(i)) && !parameterTypeName2.equals(_TYPE_UNKNOWN)) continue block1;
                }
                deprecated = true;
            }
            if (!deprecated) continue;
            this.log(methodCallAST.getLineNo(), _MSG_DEPRECATED_METHOD_CALL, new Object[]{methodName});
        }
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap() throws Exception {
        if (this._bundleSymbolicNamesMap != null) {
            return this._bundleSymbolicNamesMap;
        }
        File modulesDir = new File(this._getRootDirName() + "/modules");
        final ArrayList files = new ArrayList();
        Files.walkFileTree(modulesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                for (PathMatcher pathMatcher : _PATH_MATCHERS) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                if (_PATH_MATCHER.matches(filePath)) {
                    files.add(filePath.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        this._bundleSymbolicNamesMap = new HashMap<String, String>();
        for (File file : files) {
            String content = FileUtil.read(file);
            String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
            if (bundleSymbolicName == null || !bundleSymbolicName.startsWith("com.liferay")) continue;
            this._bundleSymbolicNamesMap.put(bundleSymbolicName, SourceUtil.getAbsolutePath(file.getParentFile()));
        }
        return this._bundleSymbolicNamesMap;
    }

    private File _getFile(String fullyQualifiedName) {
        File file;
        if (fullyQualifiedName.contains(".kernel.") && (file = this._getFile(fullyQualifiedName, "portal-kernel/src/", "portal-test/src/", "portal-impl/test/integration/", "portal-impl/test/unit/")) != null) {
            return file;
        }
        if ((fullyQualifiedName.startsWith("com.liferay.portal.") || fullyQualifiedName.startsWith("com.liferay.portlet.")) && (file = this._getFile(fullyQualifiedName, "portal-impl/src/", "portal-test/src/", "portal-test-integration/src/", "portal-impl/test/integration/", "portal-impl/test/unit/")) != null) {
            return file;
        }
        if (fullyQualifiedName.contains(".taglib.") && (file = this._getFile(fullyQualifiedName, "util-taglib/src/")) != null) {
            return file;
        }
        try {
            file = this._getModuleFile(fullyQualifiedName, this._getBundleSymbolicNamesMap());
            if (file != null) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private File _getFile(String fullyQualifiedName, String ... dirNames) {
        for (String dirName : dirNames) {
            StringBundler sb = new StringBundler(5);
            sb.append(this._getRootDirName());
            sb.append("/");
            sb.append(dirName);
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            File file = new File(sb.toString());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private Tuple _getJavaMethodsTuple(DetailAST methodCallAST, String className, String packageName, List<String> importNames, String directoryPath) {
        DetailAST firstChildAST = methodCallAST.getFirstChild();
        if (firstChildAST.getType() == 58) {
            return this._getJavaMethodsTuple(packageName + "." + className, directoryPath);
        }
        if ((firstChildAST = firstChildAST.getFirstChild()).getType() != 58) {
            return null;
        }
        String s = firstChildAST.getText();
        if (s.matches("_?[a-z].*") && Validator.isNull(s = DetailASTUtil.getVariableTypeName(methodCallAST, s, false))) {
            return null;
        }
        for (String importName : importNames) {
            if (!importName.endsWith("." + s)) continue;
            return this._getJavaMethodsTuple(importName, null);
        }
        return this._getJavaMethodsTuple(packageName + "." + s, directoryPath);
    }

    private Tuple _getJavaMethodsTuple(File file) {
        boolean inheritsThirdParty = false;
        ArrayList<JavaMethod> javaMethods = new ArrayList<JavaMethod>();
        try {
            String content = FileUtil.read(file);
            JavaClass javaClass = JavaClassParser.parseJavaClass(SourceUtil.getAbsolutePath(file), content);
            for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
                if (!javaTerm.isJavaMethod()) continue;
                JavaMethod javaMethod = (JavaMethod)javaTerm;
                javaMethods.add(javaMethod);
            }
            List<String> inheritedClassNames = javaClass.getExtendedClassNames();
            inheritedClassNames.addAll(javaClass.getImplementedClassNames());
            for (String inheritedClassName : inheritedClassNames) {
                String fullyQualifiedName = null;
                if (inheritedClassName.matches("([a-z]\\w*\\.){2,}[A-Z]\\w*")) {
                    fullyQualifiedName = inheritedClassName;
                } else {
                    for (String importName : javaClass.getImports()) {
                        if (!importName.endsWith("." + inheritedClassName)) continue;
                        fullyQualifiedName = importName;
                        break;
                    }
                }
                Tuple inheritedJavaMethodsTuple = null;
                if (fullyQualifiedName != null) {
                    inheritedJavaMethodsTuple = this._getJavaMethodsTuple(fullyQualifiedName, null);
                } else {
                    fullyQualifiedName = javaClass.getPackageName() + "." + inheritedClassName;
                    String absolutePath = SourceUtil.getAbsolutePath(file);
                    int x = absolutePath.lastIndexOf("/");
                    String directoryPath = absolutePath.substring(0, x + 1);
                    inheritedJavaMethodsTuple = this._getJavaMethodsTuple(fullyQualifiedName, directoryPath);
                }
                List inheritedJavaMethods = (List)inheritedJavaMethodsTuple.getObject(0);
                javaMethods.addAll(inheritedJavaMethods);
                if (inheritsThirdParty) continue;
                inheritsThirdParty = (Boolean)inheritedJavaMethodsTuple.getObject(1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Tuple(javaMethods, inheritsThirdParty);
    }

    private Tuple _getJavaMethodsTuple(String fullyQualifiedName, String directoryPath) {
        Tuple javaMethodsTuple = this._javaMethodsTupleMap.get(fullyQualifiedName);
        if (javaMethodsTuple != null) {
            return javaMethodsTuple;
        }
        File file = null;
        if (directoryPath != null) {
            int y = fullyQualifiedName.lastIndexOf(".");
            String fileName = directoryPath + fullyQualifiedName.substring(y + 1) + ".java";
            file = new File(fileName);
            if (!file.exists()) {
                return new Tuple(Collections.emptyList(), true);
            }
        } else {
            file = this._getFile(fullyQualifiedName);
        }
        if (file == null) {
            return new Tuple(Collections.emptyList(), true);
        }
        javaMethodsTuple = this._getJavaMethodsTuple(file);
        if (javaMethodsTuple == null) {
            return null;
        }
        this._javaMethodsTupleMap.put(fullyQualifiedName, javaMethodsTuple);
        return javaMethodsTuple;
    }

    private File _getModuleFile(String fullyQualifiedName, Map<String, String> bundleSymbolicNamesMap) {
        for (Map.Entry<String, String> entry : bundleSymbolicNamesMap.entrySet()) {
            String bundleSymbolicName = entry.getKey();
            String modifiedBundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|impl|service|test)$", "");
            if (!fullyQualifiedName.startsWith(modifiedBundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(4);
            sb.append(entry.getValue());
            sb.append("/src/main/java/");
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            File file = new File(sb.toString());
            if (file.exists()) {
                return file;
            }
            sb = new StringBundler(4);
            sb.append(entry.getValue());
            sb.append("/src/testIntegration/java/");
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            file = new File(sb.toString());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private String _getPackageName(DetailAST detailAST) {
        DetailAST sibling = detailAST.getPreviousSibling();
        while (sibling != null) {
            if (sibling.getType() == 16) {
                DetailAST dotAST = sibling.findFirstToken(59);
                FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotAST);
                return fullIdent.getText();
            }
            sibling = sibling.getPreviousSibling();
        }
        return null;
    }

    private List<JavaParameter> _getParameters(JavaMethod method) {
        JavaSignature signature = method.getSignature();
        return signature.getParameters();
    }

    private List<String> _getParameterTypeNames(DetailAST methodCallAST) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        DetailAST elistAST = methodCallAST.findFirstToken(34);
        List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elistAST, false, 28);
        for (DetailAST exprAST : exprASTList) {
            DetailAST firstChild = exprAST.getFirstChild();
            if (firstChild.getType() == 58) {
                String parameterName = firstChild.getText();
                String parameterTypeName = DetailASTUtil.getVariableTypeName(methodCallAST, parameterName, false);
                if (Validator.isNotNull(parameterTypeName)) {
                    parameterTypeNames.add(parameterTypeName);
                    continue;
                }
                parameterTypeNames.add(_TYPE_UNKNOWN);
                continue;
            }
            if (firstChild.getType() == 139) {
                parameterTypeNames.add("String");
                continue;
            }
            parameterTypeNames.add(_TYPE_UNKNOWN);
        }
        return parameterTypeNames;
    }

    private synchronized String _getRootDirName() {
        int x;
        File file;
        if (this._rootDirName != null) {
            return this._rootDirName;
        }
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        String absolutePath = SourceUtil.getAbsolutePath(fileName);
        do {
            if ((x = absolutePath.lastIndexOf("/")) != -1) continue;
            return null;
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        return absolutePath;
    }

    private boolean _hasDeprecatedParent(DetailAST methodCallAST) {
        DetailAST parentAST = methodCallAST.getParent();
        while (parentAST != null) {
            if ((parentAST.getType() == 9 || parentAST.getType() == 10) && AnnotationUtility.containsAnnotation((DetailAST)parentAST, (String)"Deprecated")) {
                return true;
            }
            parentAST = parentAST.getParent();
        }
        return false;
    }
}

