/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class JavadocCheck
extends BaseCheck {
    private static final String _MSG_EMPTY_LINE = "javadoc.empty.line";
    private static final String _MSG_INCORRECT_FIRST_LINE = "javadoc.incorrect.first.line";
    private static final String _MSG_INCORRECT_LAST_LINE = "javadoc.incorrect.last.line";
    private static final String _MSG_MULTIPLE_JAVADOC = "javadoc.multiple";

    public int[] getDefaultTokens() {
        return new int[]{157, 161, 14, 8, 155, 154, 15, 9, 16, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        TextBlock javadoc = fileContents.getJavadocBefore(detailAST.getLineNo());
        if (javadoc == null || this._containsCopyright(javadoc)) {
            return;
        }
        this._checkJavadoc(javadoc);
        javadoc = fileContents.getJavadocBefore(javadoc.getStartLineNo());
        if (javadoc != null) {
            DetailAST nameAST = detailAST.findFirstToken(58);
            this.log(detailAST.getLineNo(), _MSG_MULTIPLE_JAVADOC, new Object[]{nameAST.getText()});
        }
    }

    private void _checkJavadoc(TextBlock javadoc) {
        String[] text = javadoc.getText();
        this._checkLine(javadoc, text, 1, "/**", _MSG_INCORRECT_FIRST_LINE, true);
        this._checkLine(javadoc, text, 2, "*", _MSG_EMPTY_LINE, false);
        this._checkLine(javadoc, text, text.length - 1, "*", _MSG_EMPTY_LINE, false);
        this._checkLine(javadoc, text, text.length, "*/", _MSG_INCORRECT_LAST_LINE, true);
    }

    private void _checkLine(TextBlock javadoc, String[] text, int lineNumber, String expectedValue, String message, boolean match) {
        String line = StringUtil.trim(text[lineNumber - 1]);
        if (match && !line.equals(expectedValue) || !match && line.equals(expectedValue)) {
            this.log(javadoc.getStartLineNo() + lineNumber - 1, message, new Object[0]);
        }
    }

    private boolean _containsCopyright(TextBlock javadoc) {
        String[] text;
        if (javadoc.getStartLineNo() != 1) {
            return false;
        }
        for (String line : text = javadoc.getText()) {
            if (!line.contains("Copyright (c) 2000-present Liferay, Inc.")) continue;
            return true;
        }
        return false;
    }
}

