/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceAnnotationCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_GREEDY_POLICY_OPTION = "greedy.policy.option.incorrect";
    private static final String _MSG_INCORRECT_VOLATILE = "volatile.incorrect";
    private static final String _MSG_MISSING_DYNAMIC_POLICY_UNBIND = "unbind.dynamic.policy.missing";
    private static final String _MSG_MISSING_STATIC_POLICY_UNBIND = "unbind.static.policy.missing";
    private static final String _MSG_MISSING_VOLATILE = "volatile.missing";
    private static final String _MSG_REDUNDANT_DEFAULT_UNBIND = "default.unbind.redundant";
    private static final String _NO_UNBIND = "\"-\"";
    private static final String _POLICY_DYNAMIC = "DYNAMIC";
    private static final String _POLICY_OPTION_GREEDY = "GREEDY";
    private static final String _POLICY_OPTION_RELUCTANT = "RELUCTANT";
    private static final String _POLICY_STATIC = "STATIC";
    private final Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");

    public int[] getDefaultTokens() {
        return new int[]{9, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> importNames = DetailASTUtil.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.service.component.annotations.Reference")) {
            return;
        }
        List<DetailAST> annotationASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 159);
        for (DetailAST annotationAST : annotationASTList) {
            String name;
            DetailAST identAST = annotationAST.findFirstToken(58);
            if (identAST == null || !(name = identAST.getText()).equals("Reference")) continue;
            String policyName = this._getAnnotationMemberValue(annotationAST, "policy", _POLICY_STATIC);
            this._checkGreedyOption(annotationAST, policyName);
            if (detailAST.getType() == 10) {
                this._checkVolatileVariable(detailAST, policyName);
                continue;
            }
            DetailAST classDefAST = DetailASTUtil.getParentWithTokenType(detailAST, 14);
            if (classDefAST == null) continue;
            this._checkUnbind(classDefAST, detailAST, annotationAST, policyName);
            this._checkVolatileReferenceVariable(classDefAST, detailAST);
        }
    }

    private void _checkGreedyOption(DetailAST annotationAST, String policyName) {
        String policyOptionName = this._getAnnotationMemberValue(annotationAST, "policyOption", _POLICY_OPTION_RELUCTANT);
        if (policyOptionName.endsWith(_POLICY_OPTION_GREEDY) && policyName.endsWith(_POLICY_STATIC)) {
            this.log(annotationAST.getLineNo(), _MSG_INCORRECT_GREEDY_POLICY_OPTION, new Object[0]);
        }
    }

    private void _checkUnbind(DetailAST classDefAST, DetailAST detailAST, DetailAST annotationAST, String policyName) {
        DetailAST identAST = detailAST.findFirstToken(58);
        String methodName = identAST.getText();
        String defaultUnbindMethodName = this._getDefaultUnbindMethodName(methodName);
        String unbindName = this._getAnnotationMemberValue(annotationAST, "unbind", null);
        if (unbindName == null) {
            if (!this._containsMethod(classDefAST, defaultUnbindMethodName)) {
                if (policyName.endsWith(_POLICY_DYNAMIC)) {
                    this.log(annotationAST.getLineNo(), _MSG_MISSING_DYNAMIC_POLICY_UNBIND, new Object[0]);
                } else {
                    this.log(annotationAST.getLineNo(), _MSG_MISSING_STATIC_POLICY_UNBIND, new Object[]{_NO_UNBIND});
                }
            }
        } else if (unbindName.equals("\"" + defaultUnbindMethodName + "\"")) {
            this.log(annotationAST.getLineNo(), _MSG_REDUNDANT_DEFAULT_UNBIND, new Object[0]);
        } else if (unbindName.equals(_NO_UNBIND) && policyName.endsWith(_POLICY_DYNAMIC)) {
            this.log(annotationAST.getLineNo(), _MSG_MISSING_DYNAMIC_POLICY_UNBIND, new Object[0]);
        }
    }

    private void _checkVolatileReferenceVariable(DetailAST classDefAST, DetailAST methodDefAST) {
        String methodBody = this._getMethodBody(methodDefAST);
        Matcher matcher = this._referenceMethodContentPattern.matcher(StringUtil.trim(methodBody));
        if (!matcher.find()) {
            return;
        }
        String variableName = matcher.group(1);
        List<DetailAST> variableDefASTList = DetailASTUtil.getAllChildTokens(classDefAST, true, 10);
        for (DetailAST variableDefAST : variableDefASTList) {
            DetailAST modifiersAST;
            DetailAST identAST = variableDefAST.findFirstToken(58);
            if (!variableName.equals(identAST.getText()) || !(modifiersAST = variableDefAST.findFirstToken(5)).branchContains(61) || !modifiersAST.branchContains(68)) continue;
            this.log(identAST.getLineNo(), _MSG_INCORRECT_VOLATILE, new Object[]{variableName});
            return;
        }
    }

    private void _checkVolatileVariable(DetailAST variableDefAST, String policyName) {
        if (!policyName.endsWith(_POLICY_DYNAMIC)) {
            return;
        }
        DetailAST modifiersAST = variableDefAST.findFirstToken(5);
        if (!modifiersAST.branchContains(68)) {
            DetailAST identAST = variableDefAST.findFirstToken(58);
            this.log(identAST.getLineNo(), _MSG_MISSING_VOLATILE, new Object[]{identAST.getText()});
        }
    }

    private boolean _containsMethod(DetailAST classDefAST, String methodName) {
        List<DetailAST> methodDefASTList = DetailASTUtil.getAllChildTokens(classDefAST, true, 9);
        for (DetailAST methodDefAST : methodDefASTList) {
            DetailAST identAST = methodDefAST.findFirstToken(58);
            if (!methodName.equals(identAST.getText())) continue;
            return true;
        }
        return false;
    }

    private String _getAnnotationMemberValue(DetailAST anontationAST, String name, String defaultValue) {
        List<DetailAST> annotationMemberValuePairASTList = DetailASTUtil.getAllChildTokens(anontationAST, false, 160);
        for (DetailAST annotationMemberValuePairAST : annotationMemberValuePairASTList) {
            DetailAST identAST = annotationMemberValuePairAST.findFirstToken(58);
            String annotationMemberName = identAST.getText();
            if (!annotationMemberName.equals(name)) continue;
            DetailAST expressionAST = annotationMemberValuePairAST.findFirstToken(28);
            if (expressionAST == null) {
                return null;
            }
            FullIdent expressionIdent = FullIdent.createFullIdentBelow((DetailAST)expressionAST);
            return expressionIdent.getText();
        }
        return defaultValue;
    }

    private String _getDefaultUnbindMethodName(String methodName) {
        if (methodName.startsWith("add")) {
            return StringUtil.replaceFirst(methodName, "add", "remove");
        }
        return "un" + methodName;
    }

    private String _getMethodBody(DetailAST methodDefAST) {
        DetailAST slistAST = methodDefAST.findFirstToken(7);
        int start = DetailASTUtil.getStartLine(slistAST);
        int end = DetailASTUtil.getEndLine(slistAST);
        StringBundler sb = new StringBundler((end - start - 1) * 2);
        for (int i = start + 1; i < end; ++i) {
            sb.append(this.getLine(i - 1));
            sb.append("\n");
        }
        return sb.toString();
    }
}

