/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationsCheck
extends BaseFileCheck {
    private final Pattern _annotationLineBreakPattern1 = Pattern.compile("[{=]\n.*(\" \\+\n\t*\")");
    private final Pattern _annotationLineBreakPattern2 = Pattern.compile("=(\n\t*)\"");
    private final Pattern _annotationMetaTypePattern = Pattern.compile("[\\s\\(](name|description) = \"%");
    private final Pattern _annotationMetaValueKeyPattern = Pattern.compile("\\s(\\w+) = \"([\\w\\.\\-]+?)\"");
    private final Pattern _annotationParameterPropertyPattern = Pattern.compile("\t(\\w+) = \\{");
    private final Pattern _modifierPattern = Pattern.compile("[^\n]\n(\t*)(public|protected|private)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        return this._formatAnnotations(fileName, content);
    }

    private void _checkDelimeter(String fileName, String content, Matcher matcher, String key, String correctDelimeter, String incorrectDelimeter) {
        if (!key.equals(matcher.group(1))) {
            return;
        }
        String value = matcher.group(2);
        if (!value.contains(incorrectDelimeter)) {
            return;
        }
        StringBundler sb = new StringBundler(7);
        sb.append("Value '");
        sb.append(value);
        sb.append("' for key '");
        sb.append(key);
        sb.append("' should use '");
        sb.append(correctDelimeter);
        sb.append("' as delimeter");
        this.addMessage(fileName, sb.toString(), "meta_annotations.markdown", this.getLineCount(content, content.indexOf(matcher.group())));
    }

    private void _checkMetaAnnotationKeys(String fileName, String content, String annotation) {
        if (!annotation.contains("@Meta.")) {
            return;
        }
        Matcher matcher = this._annotationMetaValueKeyPattern.matcher(annotation);
        while (matcher.find()) {
            this._checkDelimeter(fileName, content, matcher, "description", "-", ".");
            this._checkDelimeter(fileName, content, matcher, "id", ".", "-");
            this._checkDelimeter(fileName, content, matcher, "name", "-", ".");
        }
    }

    private String _fixAnnotationLineBreaks(String annotation, String indent) {
        Matcher matcher = this._annotationLineBreakPattern1.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), "", matcher.start());
        }
        matcher = this._annotationLineBreakPattern2.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), " ", matcher.start());
        }
        if (annotation.matches(".*\\(\n[\\S\\s]*[^\t\n]\\)\n")) {
            return StringUtil.replaceLast(annotation, ")", "\n" + indent + ")");
        }
        return annotation;
    }

    private String _fixAnnotationMetaTypeProperties(String annotation) {
        if (!annotation.contains("@Meta.")) {
            return annotation;
        }
        Matcher matcher = this._annotationMetaTypePattern.matcher(annotation);
        if (!matcher.find()) {
            return annotation;
        }
        return StringUtil.replaceFirst(annotation, "%", "", matcher.start());
    }

    private String _fixSingleValueArray(String annotation) {
        String replacement;
        String arrayString;
        int x = -1;
        block0: while (true) {
            if ((x = annotation.indexOf("= {", x + 1)) == -1) {
                return annotation;
            }
            if (ToolsUtil.isInsideQuotes(annotation, x)) continue;
            arrayString = null;
            int y = x;
            do {
                if ((y = annotation.indexOf("}", y + 1)) != -1) continue;
                return annotation;
            } while (ToolsUtil.isInsideQuotes(annotation, y) || this.getLevel(arrayString = annotation.substring(x + 2, y + 1), "{", "}") != 0);
            y = -1;
            while ((y = arrayString.indexOf(",", y + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(arrayString, y)) continue;
                continue block0;
            }
            replacement = StringUtil.trim(arrayString.substring(1, arrayString.length() - 1));
            if (Validator.isNotNull(replacement)) break;
        }
        return StringUtil.replace(annotation, arrayString, replacement);
    }

    private String _formatAnnotationParameterProperties(String annotation) {
        if (!annotation.contains("@Component(")) {
            return annotation;
        }
        Matcher matcher = this._annotationParameterPropertyPattern.matcher(annotation);
        while (matcher.find()) {
            int x = matcher.end();
            while (ToolsUtil.isInsideQuotes(annotation, x = annotation.indexOf(125, x + 1))) {
            }
            String parameterProperties = annotation.substring(matcher.end(), x);
            String newParameterProperties = StringUtil.replace(parameterProperties, new String[]{" =", "= "}, new String[]{"=", "="});
            if (!parameterProperties.equals(newParameterProperties)) {
                return StringUtil.replaceFirst(annotation, parameterProperties, newParameterProperties);
            }
            parameterProperties = StringUtil.replace(parameterProperties, new String[]{"\t", "    ", "\n"}, new String[]{"", "", " "});
            if ((parameterProperties = StringUtil.trim(parameterProperties)).startsWith("@")) continue;
            String[] parameterPropertiesArray = StringUtil.split(parameterProperties, ", ");
            AnnotationParameterPropertyComparator comparator = new AnnotationParameterPropertyComparator(matcher.group(1));
            for (int i = 1; i < parameterPropertiesArray.length; ++i) {
                String previousParameterProperty = parameterPropertiesArray[i - 1];
                String parameterProperty = parameterPropertiesArray[i];
                if (comparator.compare(previousParameterProperty, parameterProperty) <= 0) continue;
                annotation = StringUtil.replaceFirst(annotation, previousParameterProperty, parameterProperty);
                annotation = StringUtil.replaceLast(annotation, parameterProperty, previousParameterProperty);
                return annotation;
            }
        }
        return annotation;
    }

    private String _formatAnnotations(String fileName, String content) throws Exception {
        List<String> annotationsBlocks = this._getAnnotationsBlocks(content);
        for (String annotationsBlock : annotationsBlocks) {
            String indent = this._getIndent(annotationsBlock);
            String newAnnotationsBlock = this._formatAnnotations(fileName, content, annotationsBlock, indent, true);
            content = StringUtil.replace(content, "\n" + annotationsBlock, "\n" + newAnnotationsBlock);
        }
        return content;
    }

    private String _formatAnnotations(String fileName, String content, String annotationsBlock, String indent, boolean sortAnnotations) throws Exception {
        List<String> annotations = this._splitAnnotations(annotationsBlock, indent);
        String previousAnnotation = null;
        for (String annotation : annotations) {
            String newAnnotation = annotation;
            if (newAnnotation.contains("(")) {
                newAnnotation = this._fixAnnotationLineBreaks(newAnnotation, indent);
                newAnnotation = this._fixAnnotationMetaTypeProperties(newAnnotation);
                newAnnotation = this._fixSingleValueArray(newAnnotation);
                newAnnotation = this._formatAnnotationParameterProperties(newAnnotation);
                this._checkMetaAnnotationKeys(fileName, content, newAnnotation);
                newAnnotation = this._formatAnnotations(fileName, content, newAnnotation, indent + "\t\t", false);
                annotationsBlock = StringUtil.replace(annotationsBlock, annotation, newAnnotation);
            }
            if (!sortAnnotations) continue;
            if (Validator.isNotNull(previousAnnotation) && previousAnnotation.compareToIgnoreCase(newAnnotation) > 0) {
                annotationsBlock = StringUtil.replaceFirst(annotationsBlock, previousAnnotation, newAnnotation);
                annotationsBlock = StringUtil.replaceLast(annotationsBlock, newAnnotation, previousAnnotation);
            }
            previousAnnotation = newAnnotation;
        }
        return annotationsBlock;
    }

    private List<String> _getAnnotationsBlocks(String content) {
        ArrayList<String> annotationsBlocks = new ArrayList<String>();
        Matcher matcher = this._modifierPattern.matcher(content);
        block0: while (matcher.find()) {
            int lineCount = this.getLineCount(content, matcher.end());
            String annotationsBlock = "";
            int i = lineCount - 1;
            while (true) {
                String line;
                if (Validator.isNull(line = this.getLine(content, i)) || line.matches("\t*(private|public|protected| \\*/).*")) {
                    if (!Validator.isNotNull(annotationsBlock)) continue block0;
                    annotationsBlocks.add(annotationsBlock);
                    continue block0;
                }
                annotationsBlock = line + "\n" + annotationsBlock;
                --i;
            }
        }
        return annotationsBlocks;
    }

    private String _getIndent(String s) {
        StringBundler sb = new StringBundler();
        for (char c : s.toCharArray()) {
            if (c != '\t') break;
            sb.append(c);
        }
        return sb.toString();
    }

    private List<String> _splitAnnotations(String annotationsBlock, String indent) throws Exception {
        ArrayList<String> annotations = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(annotationsBlock));){
            String annotation = null;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (annotation == null) {
                    if (!line.startsWith(indent + "@")) continue;
                    annotation = line + "\n";
                    continue;
                }
                String lineIndent = this._getIndent(line);
                if (lineIndent.length() < indent.length()) {
                    annotations.add(annotation);
                    annotation = null;
                    continue;
                }
                if (line.startsWith(indent + "@")) {
                    annotations.add(annotation);
                    annotation = line + "\n";
                    continue;
                }
                annotation = annotation + line + "\n";
            }
            if (Validator.isNotNull(annotation)) {
                annotations.add(annotation);
            }
        }
        return annotations;
    }

    private class AnnotationParameterPropertyComparator
    extends NaturalOrderStringComparator {
        private final String _parameterName;

        public AnnotationParameterPropertyComparator(String parameterName) {
            this._parameterName = parameterName;
        }

        @Override
        public int compare(String property1, String property2) {
            String propertyName2;
            if (!this._parameterName.equals("property")) {
                return super.compare(property1, property2);
            }
            String propertyName1 = this._getPropertyName(property1);
            if (propertyName1.equals(propertyName2 = this._getPropertyName(property2))) {
                return super.compare(property1, property2);
            }
            int value = super.compare(propertyName1, propertyName2);
            if (propertyName1.startsWith("\"") ^ propertyName2.startsWith("\"")) {
                return -value;
            }
            return value;
        }

        private String _getPropertyName(String property) {
            int x = property.indexOf("=");
            if (x != -1) {
                return property.substring(0, x);
            }
            return property;
        }
    }
}

