/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.LineBreakCheck;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLineBreakCheck
extends LineBreakCheck {
    private final Pattern _arrayPattern = Pattern.compile("(\n\t*.* =) ((new \\w*\\[\\] )?\\{)\n(\t*)([^\t\\{].*)\n\t*(\\};?)\n");
    private final Pattern _catchStatemementPattern = Pattern.compile("\n((\t*)catch \\((.*[^{|\\s])?\n[^}]*?\\) \\{)\n");
    private final Pattern _classOrEnumPattern = Pattern.compile("(\n(\t*)(private|protected|public) ((abstract|static) )*(class|enum|interface) ([\\s\\S]*?)\\{)((.*)\\})?([ \t]*(\\Z|\n)(\\s*)(\\S))");
    private final Pattern _incorrectLineBreakInsideChainPattern1 = Pattern.compile("\n(\t*)\\).*?\\((.+)");
    private final Pattern _incorrectLineBreakInsideChainPattern2 = Pattern.compile("\t\\)\\..*\\(\n");
    private final Pattern _incorrectLineBreakInsideChainPattern3 = Pattern.compile("\n(.*\\S)\\)\\.(.*)\\(\n");
    private final Pattern _incorrectLineBreakInsideChainPattern4 = Pattern.compile("\t(\\)\\.[^\\)\\(]+\\()(.+)\n");
    private final Pattern _incorrectLineBreakPattern1 = Pattern.compile("\n(\t*)(.*\\) \\{)([\t ]*\\}\n)");
    private final Pattern _incorrectLineBreakPattern2 = Pattern.compile("\n(\t*).*\\}\n(\t*)\\);");
    private final Pattern _incorrectLineBreakPattern3 = Pattern.compile("\n(\t*)\\{.+(?<!\\}\\){0,10}(,|;)?)\n");
    private final Pattern _incorrectLineBreakPattern4 = Pattern.compile("\n(\t+\\{)\n(.*[^;])\n\t+(\\},?)");
    private final Pattern _incorrectLineBreakPattern5 = Pattern.compile(", (new .*\\(.*\\) \\{)\n");
    private final Pattern _incorrectLineBreakPattern6 = Pattern.compile("^(((else )?if|for|try|while) \\()?\\(*(.*\\()$");
    private final Pattern _incorrectLineBreakPattern7 = Pattern.compile("(\t+)for \\(.*:(.+\\()\n[\\s\\S]+?\\) \\{\n");
    private final Pattern _incorrectMultiLineCommentPattern = Pattern.compile("(\n\t*/\\*)\n\t*(.*?)\n\t*(\\*/\n)", 32);
    private final Pattern _lineStartingWithCloseParenthesisPattern = Pattern.compile("(.)\n+(\t+)\\)[^.].*\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.startsWith(";")) {
                    this.addMessage(fileName, "Line should not start with ';'", lineCount);
                }
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*") && trimmedLine.startsWith(".")) {
                    this.addMessage(fileName, "Line should not start with '.'", lineCount);
                }
                int lineLength = this.getLineLength(line);
                if (!(line.startsWith("import ") || line.startsWith("package ") || trimmedLine.startsWith("*") || lineLength > this.getMaxLineLength())) {
                    this._checkLineBreaks(line, previousLine, fileName, lineCount);
                }
                previousLine = line;
            }
        }
        content = this._fixIncorrectCatchStatementLineBreaks(content);
        content = this._fixIncorrectLineBreaksInsideChains(content, fileName);
        content = this._fixIncorrectLineBreaks(content, fileName);
        content = this._fixLineStartingWithCloseParenthesis(content, fileName);
        content = this._fixMultiLineComment(content);
        content = this._fixArrayLineBreaks(content);
        content = this._fixClassOrEnumLineLineBreaks(content);
        content = this.fixRedundantCommaInsideArray(content);
        return content;
    }

    private void _checkLambdaLineBreaks(String line, String fileName, int lineCount) {
        if (!line.endsWith("{") || this.getLevel(line) <= 0) {
            return;
        }
        int pos = line.indexOf("->");
        if (pos == -1 || ToolsUtil.isInsideQuotes(line, pos)) {
            return;
        }
        int x = 1;
        while (true) {
            String s;
            if (this.getLevel(s = line.substring(0, x)) > 0) {
                this.addMessage(fileName, "There should be a line break after '" + s + "'", lineCount);
                return;
            }
            ++x;
        }
    }

    private void _checkLineBreaks(String line, String previousLine, String fileName, int lineCount) {
        int x;
        Matcher matcher;
        int x2;
        this.checkLineBreaks(line, previousLine, fileName, lineCount);
        String trimmedLine = StringUtil.trimLeading(line);
        if (previousLine.contains("\t/*") || trimmedLine.startsWith("//") | trimmedLine.startsWith("/*") || trimmedLine.endsWith("*/")) {
            return;
        }
        this._checkLambdaLineBreaks(trimmedLine, fileName, lineCount);
        if (trimmedLine.endsWith("( {")) {
            this.addMessage(fileName, "There should be a line before ' {'", lineCount);
        }
        int x3 = 0;
        while ((x3 = trimmedLine.indexOf("}", x3 + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(trimmedLine, x3) || this.getLevel(trimmedLine.substring(0, x3 + 1), "{", "}") >= 0) continue;
            this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x3) + "'", lineCount);
        }
        if (previousLine.endsWith(".") && (x3 = trimmedLine.indexOf(40)) != -1 && this.getLineLength(previousLine) + x3 < this.getMaxLineLength() && (trimmedLine.endsWith("(") || trimmedLine.charAt(x3 + 1) != ')')) {
            this.addMessage(fileName, "Incorrect line break", lineCount);
        }
        String strippedQuotesLine = this.stripQuotes(trimmedLine);
        if (line.matches(".*(\\(|->( \\{)?)")) {
            String linePart;
            int pos;
            int y;
            x2 = line.lastIndexOf(" && ");
            int z = Math.max(x2, y = line.lastIndexOf(" || "));
            if (z != -1) {
                this.addMessage(fileName, "There should be a line break after '" + line.substring(z + 1, z + 3) + "'", lineCount);
            }
            if ((pos = strippedQuotesLine.indexOf(" + ")) != -1 && this.getLevel(linePart = strippedQuotesLine.substring(0, pos), "(", ")") == 0 && this.getLevel(linePart, "[", "]") == 0) {
                this.addMessage(fileName, "There should be a line break after '+'", lineCount);
            }
        }
        if (line.matches(".*(\\(|\\^|\\&|\\||->( \\{)?)")) {
            x2 = trimmedLine.length() + 1;
            while ((x2 = trimmedLine.lastIndexOf(",", x2 - 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x2)) continue;
                String linePart = trimmedLine.substring(x2, trimmedLine.length() - 1);
                if (this.getLevel(linePart = StringUtil.removeSubstring(linePart, "->")) != 0 || this.getLevel(linePart, "<", ">") != 0) continue;
                this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x2 + 1) + "'", lineCount);
                break;
            }
        }
        if (trimmedLine.matches("^[^(].*\\+$") && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "There should be a line break after '('", lineCount);
        }
        if (!trimmedLine.contains("\t//") && !line.endsWith("{") && strippedQuotesLine.contains("{") && !strippedQuotesLine.contains("}")) {
            this.addMessage(fileName, "There should be a line break after '{'", lineCount);
        }
        if (line.endsWith(" throws") || (previousLine.endsWith(",") || previousLine.endsWith("(")) && line.contains(" throws ") && (line.endsWith("{") || line.endsWith(";"))) {
            this.addMessage(fileName, "There should be a line break before 'throws'", lineCount);
        }
        if (line.endsWith(".") && line.contains("=")) {
            this.addMessage(fileName, "There should be a line break after '='", lineCount);
        }
        if (trimmedLine.matches("^\\} (catch|else|finally) .*")) {
            this.addMessage(fileName, "There should be a line break after '}'", lineCount);
        }
        if ((matcher = this._incorrectLineBreakPattern6.matcher(trimmedLine)).find() && this.getLevel(matcher.group(4)) > 1) {
            x = trimmedLine.indexOf("(", matcher.start(4));
            String linePart = trimmedLine.substring(0, x + 1);
            this.addMessage(fileName, "There should be a line break after '" + linePart + "'", lineCount);
        }
        if (trimmedLine.matches("for \\(.*[^;{]")) {
            x = trimmedLine.length();
            while ((x = trimmedLine.lastIndexOf(";", x - 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x)) continue;
                this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x + 1) + "'", lineCount);
            }
        }
    }

    private String _fixArrayLineBreaks(String content) {
        Matcher matcher = this._arrayPattern.matcher(content);
        while (matcher.find()) {
            String newLine = matcher.group(4) + matcher.group(2) + matcher.group(5) + matcher.group(6);
            if (this.getLineLength(newLine) > this.getMaxLineLength()) continue;
            return StringUtil.replace(content, matcher.group(), StringBundler.concat(matcher.group(1), "\n", newLine, "\n"));
        }
        return content;
    }

    private String _fixClassOrEnumLineLineBreaks(String content) {
        Matcher matcher = this._classOrEnumPattern.matcher(content);
        while (matcher.find()) {
            String indent = matcher.group(2);
            String match = matcher.group(1);
            String inBetweenCurlyBraces = matcher.group(9);
            if (inBetweenCurlyBraces != null) {
                if (Validator.isNull(inBetweenCurlyBraces)) {
                    return StringUtil.replaceFirst(content, "}", "\n" + indent + "}", matcher.end(9));
                }
                return StringUtil.replaceFirst(content, inBetweenCurlyBraces + "}", StringBundler.concat("\n\n\t", indent, StringUtil.trim(inBetweenCurlyBraces), "\n\n", indent, "}"), matcher.start(8));
            }
            String firstTrailingNonWhitespace = matcher.group(13);
            String trailingWhitespace = matcher.group(12);
            if (!trailingWhitespace.contains("\n") && !firstTrailingNonWhitespace.equals("}")) {
                return StringUtil.replace(content, match, match + "\n");
            }
            String formattedClassLine = this._getFormattedClassLine(indent, match);
            if (formattedClassLine == null) continue;
            content = StringUtil.replace(content, match, formattedClassLine);
        }
        return content;
    }

    private String _fixIncorrectCatchStatementLineBreaks(String content) {
        Matcher matcher = this._catchStatemementPattern.matcher(content);
        while (matcher.find()) {
            String thirdLine;
            String secondLine;
            String newCatchStatement;
            String indent;
            String catchStatement = matcher.group(1);
            String singleLineCatchStatement = indent = matcher.group(2);
            for (String line : StringUtil.splitLines(catchStatement)) {
                if (!(singleLineCatchStatement.equals(indent) || singleLineCatchStatement.endsWith("(") || singleLineCatchStatement.endsWith("."))) {
                    singleLineCatchStatement = singleLineCatchStatement + " ";
                }
                singleLineCatchStatement = singleLineCatchStatement + StringUtil.trim(line);
            }
            if (this.getLineLength(singleLineCatchStatement) <= this.getMaxLineLength()) {
                return StringUtil.replaceFirst(content, catchStatement, singleLineCatchStatement, matcher.start());
            }
            int x = this._getLastIndexOf(singleLineCatchStatement, '|', this.getMaxLineLength());
            if (x != -1) {
                String newCatchStatement2 = StringUtil.insert(singleLineCatchStatement, "\n" + indent, x + 1);
                if (catchStatement.equals(newCatchStatement2)) continue;
                return StringUtil.replaceFirst(content, catchStatement, newCatchStatement2, matcher.start());
            }
            if (singleLineCatchStatement.contains("|")) continue;
            x = singleLineCatchStatement.indexOf(40);
            String firstLine = singleLineCatchStatement.substring(0, x + 1);
            String remainder = indent + "\t" + singleLineCatchStatement.substring(x + 1);
            if (this.getLineLength(remainder) <= this.getMaxLineLength()) {
                String newCatchStatement3 = firstLine + "\n" + remainder;
                if (catchStatement.equals(newCatchStatement3)) continue;
                return StringUtil.replaceFirst(content, catchStatement, newCatchStatement3, matcher.start());
            }
            x = this._getLastIndexOf(remainder, ' ', this.getMaxLineLength());
            if (x == -1) {
                x = this._getLastIndexOf(remainder, '.', this.getMaxLineLength());
            }
            if (x == -1 || catchStatement.equals(newCatchStatement = StringBundler.concat(firstLine, "\n", secondLine = remainder.substring(0, x + 1), "\n", thirdLine = indent + "\t\t" + remainder.substring(x + 1)))) continue;
            return StringUtil.replaceFirst(content, catchStatement, newCatchStatement, matcher.start());
        }
        return content;
    }

    private String _fixIncorrectLineBreaks(String content, String fileName) {
        Matcher matcher = this._incorrectLineBreakPattern1.matcher(content);
        while (matcher.find()) {
            String matchingLine = matcher.group(2);
            if (matchingLine.startsWith("//") || matchingLine.startsWith("*")) continue;
            return StringUtil.replaceFirst(content, matcher.group(3), "\n" + matcher.group(1) + "}\n", matcher.start(3) - 1);
        }
        matcher = this._incorrectLineBreakPattern2.matcher(content);
        while (matcher.find()) {
            String match;
            String tabs = matcher.group(2);
            Pattern pattern = Pattern.compile(StringBundler.concat("\n", tabs, "([^\t]{2})(?!.*\n", tabs, "[^\t])"), 32);
            Matcher matcher2 = pattern.matcher(content.substring(0, matcher.start(2)));
            if (!matcher2.find() || (match = matcher2.group(1)).equals(").")) continue;
            return StringUtil.replaceFirst(content, "\n" + matcher.group(2), "", matcher.end(1));
        }
        matcher = this._incorrectLineBreakPattern3.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "{", "{\n" + matcher.group(1) + "\t", matcher.start());
        }
        matcher = this._incorrectLineBreakPattern4.matcher(content);
        while (matcher.find()) {
            String singleLine;
            if (content.charAt(matcher.end()) != '\n' || this.getLineLength(singleLine = matcher.group(1) + StringUtil.trimLeading(matcher.group(2)) + matcher.group(3)) > this.getMaxLineLength()) continue;
            return StringUtil.replace(content, matcher.group(), "\n" + singleLine);
        }
        matcher = this._incorrectLineBreakPattern7.matcher(content);
        while (matcher.find()) {
            String linePart = matcher.group(2);
            if (this.getLevel(linePart) != 1) continue;
            if (StringUtil.count(matcher.group(), '\n') > 2) {
                this.addMessage(fileName, "For better readability, create new var for the array in the 'for' statement", this.getLineCount(content, matcher.start()));
                continue;
            }
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "\n\t", "\n\t\t");
            replacement = StringUtil.replaceFirst(replacement, linePart, "\n\t\t" + matcher.group(1) + StringUtil.trim(linePart));
            return StringUtil.replace(content, match, replacement);
        }
        matcher = this._incorrectLineBreakPattern5.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) != 0) continue;
            int lineCount = this.getLineCount(content, matcher.start());
            this.addMessage(fileName, "There should be a line break before '" + matcher.group(1) + "'", lineCount);
        }
        return content;
    }

    private String _fixIncorrectLineBreaksInsideChains(String content, String fileName) {
        Matcher matcher = this._incorrectLineBreakInsideChainPattern1.matcher(content);
        while (matcher.find()) {
            String linePart = matcher.group(2);
            if (!linePart.matches("\\)[^\\)]+[\\(;]")) continue;
            return StringUtil.insert(content, "\n" + matcher.group(1), matcher.start(2));
        }
        matcher = this._incorrectLineBreakInsideChainPattern2.matcher(content);
        while (matcher.find()) {
            String s;
            int x = matcher.end();
            do {
                if ((x = content.indexOf(")", x + 1)) != -1) continue;
                return content;
            } while (ToolsUtil.isInsideQuotes(content, x) || this.getLevel(s = content.substring(matcher.end(), x)) != 0);
            char c = content.charAt(x - 1);
            if (c == '\t') continue;
            int y = content.lastIndexOf("\t", x);
            s = content.substring(y + 1, x);
            this.addMessage(fileName, "There should be a line break after '" + s + "'", this.getLineCount(content, x));
        }
        matcher = this._incorrectLineBreakInsideChainPattern3.matcher(content);
        while (matcher.find()) {
            String methodName;
            if (this.getLevel(matcher.group(1)) > 0 || (methodName = matcher.group(2)).equals("concat")) continue;
            this.addMessage(fileName, "Chaining on method '" + methodName + "' is allowed, but incorrect styling", "chaining.markdown", this.getLineCount(content, matcher.end(1)));
        }
        matcher = this._incorrectLineBreakInsideChainPattern4.matcher(content);
        while (matcher.find()) {
            String s = matcher.group(2);
            if (s.matches("\\)+;?")) continue;
            this.addMessage(fileName, "There should be a line break after '" + matcher.group(1) + "'", this.getLineCount(content, matcher.start()));
        }
        return content;
    }

    private String _fixLineStartingWithCloseParenthesis(String content, String fileName) {
        Matcher matcher = this._lineStartingWithCloseParenthesisPattern.matcher(content);
        while (matcher.find()) {
            String lastCharacterPreviousLine = matcher.group(1);
            if (lastCharacterPreviousLine.equals("(")) {
                this.addMessage(fileName, "Line should not start with ')'", this.getLineCount(content, matcher.start(1)));
                return content;
            }
            int x = matcher.end(2) + 1;
            int y = x - 1;
            while (ToolsUtil.isInsideQuotes(content, y) || this.getLevel(content.substring(y, x)) != 0) {
                --y;
            }
            String trimmedLine = StringUtil.trimLeading(this.getLine(content, this.getLineCount(content, y)));
            if (trimmedLine.startsWith(").") || trimmedLine.startsWith("@")) continue;
            return StringUtil.replaceFirst(content, "\n" + matcher.group(2), "", matcher.start());
        }
        return content;
    }

    private String _fixMultiLineComment(String content) {
        Matcher matcher = this._incorrectMultiLineCommentPattern.matcher(content);
        return matcher.replaceAll("$1$2$3");
    }

    private String _getFormattedClassLine(String indent, String classLine) {
        ArrayList<String> lines;
        block15: {
            while (classLine.contains("\t ")) {
                classLine = StringUtil.replace(classLine, "\t ", "\t");
            }
            String classSingleLine = StringUtil.replace(classLine.substring(1), new String[]{"\t", "\n"}, new String[]{"", " "});
            classSingleLine = indent + classSingleLine;
            lines = new ArrayList<String>();
            if (this.getLineLength(classSingleLine) <= this.getMaxLineLength()) {
                lines.add(classSingleLine);
            } else {
                int y;
                String newIndent = indent;
                String newLine = classSingleLine;
                int x = -1;
                while ((x = (y = newLine.indexOf(" extends ", x + 1)) == -1 ? newLine.indexOf(" implements ", x + 1) : y) != -1) {
                    String linePart = newLine.substring(0, x);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this.getMaxLineLength()) continue;
                    if (lines.isEmpty()) {
                        newIndent = newIndent + "\t";
                    }
                    lines.add(linePart);
                    newLine = newIndent + newLine.substring(x + 1);
                    if (this.getLineLength(newLine) <= this.getMaxLineLength()) {
                        lines.add(newLine);
                        break block15;
                    }
                    x = -1;
                }
                if (lines.isEmpty()) {
                    return null;
                }
                x = newLine.length();
                while (true) {
                    if ((x = newLine.lastIndexOf(", ", x - 1)) == -1) {
                        return null;
                    }
                    String linePart = newLine.substring(0, x + 1);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this.getMaxLineLength()) continue;
                    lines.add(linePart);
                    if (linePart.contains("\textends")) {
                        newIndent = newIndent + "\t\t";
                    } else if (linePart.contains("\timplements")) {
                        newIndent = newIndent + "\t\t   ";
                    }
                    newLine = newIndent + newLine.substring(x + 2);
                    if (this.getLineLength(newLine) <= this.getMaxLineLength()) {
                        lines.add(newLine);
                        break;
                    }
                    x = newLine.length();
                }
            }
        }
        String formattedClassLine = null;
        for (String line : lines) {
            if (formattedClassLine == null) {
                formattedClassLine = "\n" + line;
                continue;
            }
            formattedClassLine = formattedClassLine + "\n" + line;
        }
        return formattedClassLine;
    }

    private int _getLastIndexOf(String s, char c, int fromIndex) {
        int x = s.length();
        while ((x = s.lastIndexOf(c, x - 1)) != -1 && this.getLineLength(s.substring(0, x + 1)) > fromIndex) {
        }
        return x;
    }
}

