/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStaticImportsCheck
extends BaseFileCheck {
    private final Pattern _importConstantPattern = Pattern.compile("\nimport static ((.*)\\.[A-Z_]*);");
    private final Pattern _importMethodPattern = Pattern.compile("\nimport static ((.*\\.(Assert|(Power)?Mockito))\\.[a-z]\\w*);");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb;
        Matcher matcher = this._importMethodPattern.matcher(content);
        while (matcher.find()) {
            sb = new StringBundler(5);
            sb.append("Do not import method '");
            sb.append(matcher.group(1));
            sb.append("', import class '");
            sb.append(matcher.group(2));
            sb.append("' instead");
            this.addMessage(fileName, sb.toString(), "imports.markdown", this.getLineCount(content, matcher.end()));
        }
        matcher = this._importConstantPattern.matcher(content);
        while (matcher.find()) {
            sb = new StringBundler(5);
            sb.append("Do not import constant '");
            sb.append(matcher.group(1));
            sb.append("', import class '");
            sb.append(matcher.group(2));
            sb.append("' instead or use Fully Qualified Name");
            this.addMessage(fileName, sb.toString(), "imports.markdown", this.getLineCount(content, matcher.end()));
        }
        return content;
    }
}

