/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.parser.BaseJavaTerm;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;

public class JavaClass
extends BaseJavaTerm {
    private final boolean _anonymous;
    private final List<JavaTerm> _childJavaTerms = new ArrayList<JavaTerm>();
    private List<String> _extendedClassNames = new ArrayList<String>();
    private List<String> _implementedClassNames = new ArrayList<String>();
    private List<String> _imports = new ArrayList<String>();
    private String _packageName;

    public JavaClass(String name, String content, String accessModifier, boolean isAbstract, boolean isStatic, boolean anonymous) {
        super(name, content, accessModifier, isAbstract, isStatic);
        this._anonymous = anonymous;
    }

    public void addChildJavaTerm(JavaTerm javaTerm) {
        javaTerm.setParentJavaClass(this);
        this._childJavaTerms.add(javaTerm);
    }

    public void addExtendedClassNames(String ... extendedClassNames) {
        for (String extendedClassName : extendedClassNames) {
            this._extendedClassNames.add(StringUtil.trim(extendedClassName));
        }
    }

    public void addImplementedClassNames(String ... implementedClassNames) {
        for (String implementedClassName : implementedClassNames) {
            this._implementedClassNames.add(StringUtil.trim(implementedClassName));
        }
    }

    public void addImport(String importName) {
        this._imports.add(importName);
    }

    public List<JavaTerm> getChildJavaTerms() {
        return this._childJavaTerms;
    }

    public List<String> getExtendedClassNames() {
        return this._extendedClassNames;
    }

    public List<String> getImplementedClassNames() {
        return this._implementedClassNames;
    }

    public List<String> getImports() {
        return this._imports;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
    }
}

