/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDNCheck
extends BaseFileCheck {
    private final Pattern _cdnPattern = Pattern.compile("\\S*(cdn\\.lfrs\\.sl\\/(\\w+)\\.liferay\\.com)\\S*");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        return this._fixCDNURL(content);
    }

    private String _fixCDNURL(String content) {
        Matcher matcher = this._cdnPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String s = matcher.group(2);
            if (!StringUtil.equalsIgnoreCase(s, "releases") && !StringUtil.equalsIgnoreCase(s, "repository")) continue;
            String newSub = StringUtil.toLowerCase(s) + "-cdn.liferay.com";
            newSub = StringUtil.replace(match, matcher.group(1), newSub);
            content = StringUtil.replaceFirst(content, match, newSub);
        }
        return content;
    }
}

