/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompatClassImportsCheck
extends BaseFileCheck {
    private Map<String, String> _compatClassNamesMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this.isPortalSource() || this.isSubrepository() || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        return this._fixCompatClassImports(content);
    }

    private String _fixCompatClassImports(String content) throws Exception {
        Map<String, String> compatClassNamesMap = this._getCompatClassNamesMap();
        for (Map.Entry<String, String> entry : compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(extendedClassName + "\\W");
            while ((matcher = pattern.matcher(content)).find()) {
                content = content.substring(0, matcher.start()) + compatClassName + content.substring(matcher.end() - 1);
            }
        }
        return content;
    }

    private synchronized Map<String, String> _getCompatClassNamesMap() throws Exception {
        if (this._compatClassNamesMap != null) {
            return this._compatClassNamesMap;
        }
        this._compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**/portal-compat-shared/src/com/liferay/compat/**/*.java"};
        String baseDirName = this.getBaseDirName();
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            File sharedDir = new File(baseDirName + "shared");
            if (sharedDir.exists()) {
                fileNames = this.getFileNames(baseDirName, new String[0], includes);
                break;
            }
            baseDirName = baseDirName + "../";
        }
        for (String fileName : fileNames) {
            File file = new File(fileName);
            String content = FileUtil.read(file);
            fileName = StringUtil.replace(fileName, '\\', '/');
            fileName = StringUtil.replace(fileName, '/', '.');
            int pos = fileName.indexOf("com.");
            String compatClassName = fileName.substring(pos);
            compatClassName = compatClassName.substring(0, compatClassName.length() - 5);
            String extendedClassName = StringUtil.replace(compatClassName, "compat.", "");
            if (!content.contains("extends " + extendedClassName)) continue;
            this._compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        return this._compatClassNamesMap;
    }
}

