/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.IfStatementCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPParenthesesCheck
extends IfStatementCheck {
    private final Pattern _ifStatementPattern = Pattern.compile("[\t\n]((else )?if|while) .*\\) \\{\n");
    private final Pattern _tagPattern = Pattern.compile("<%= (.+?) %>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._ifStatementPattern.matcher(content);
        while (matcher.find()) {
            int index;
            if (!JSPSourceUtil.isJavaSource(content, matcher.start()) || (index = this.checkIfClauseParentheses(matcher.group(), fileName, this.getLineNumber(content, matcher.start(1)))) == -1) continue;
            return this._fixClause(content, matcher.group(), index, matcher.start());
        }
        matcher = this._tagPattern.matcher(content);
        while (matcher.find()) {
            String ifClause;
            int index;
            if (JSPSourceUtil.isJavaSource(content, matcher.start()) || (index = this.checkIfClauseParentheses(ifClause = "if (" + matcher.group(1) + ") {", fileName, this.getLineNumber(content, matcher.start()))) == -1) continue;
            return this._fixClause(content, matcher.group(), index - 1, matcher.start() - 1);
        }
        return content;
    }

    private String _fixClause(String content, String clause, int index, int start) {
        String s;
        int x = -1;
        for (int i = 0; i < index; ++i) {
            while (ToolsUtil.isInsideQuotes(clause, x = clause.indexOf("(", x + 1))) {
            }
        }
        int y = x;
        do {
            if ((y = clause.indexOf(")", y + 1)) != -1) continue;
            return content;
        } while (ToolsUtil.isInsideQuotes(clause, y) || this.getLevel(s = clause.substring(x, y + 1)) != 0);
        String replacement = StringUtil.replaceFirst(clause, ")", "", y);
        replacement = StringUtil.replaceFirst(replacement, "(", "", x);
        return StringUtil.replaceFirst(content, clause, replacement, start);
    }
}

