/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDeprecatedJavadocCheck
extends BaseFileCheck {
    private static final String[] _OLD_RELEASE_CODE_NAMES = new String[]{"Bunyan", "Newton", "Paton", "Wilberforce"};
    private final Pattern _deprecatedPattern = Pattern.compile("(\n\\s*\\* @deprecated)( As of ([^, \n]+)(.*?)\n\\s*\\*( @|/))?", 32);
    private String _nextReleaseCodeName;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        return this._formatDeprecatedJavadoc(content);
    }

    private String _formatDeprecatedJavadoc(String content) throws Exception {
        Matcher matcher = this._deprecatedPattern.matcher(content);
        while (matcher.find()) {
            String nextReleaseCodeName;
            if (matcher.group(2) == null) {
                return StringUtil.insert(content, " As of " + this._getNextReleaseCodeName(), matcher.end(1));
            }
            String version = matcher.group(3);
            if (!ArrayUtil.contains(_OLD_RELEASE_CODE_NAMES, version) && !(nextReleaseCodeName = this._getNextReleaseCodeName()).equals(version)) {
                return StringUtil.replaceFirst(content, version, nextReleaseCodeName, matcher.start());
            }
            String deprecatedInfo = matcher.group(4);
            if (Validator.isNull(deprecatedInfo)) {
                return content;
            }
            if (!deprecatedInfo.startsWith(",")) {
                return StringUtil.insert(content, ",", matcher.end(3));
            }
            if (!deprecatedInfo.endsWith(".") || deprecatedInfo.matches("[\\S\\s]*\\.[ \n][\\S\\s]*")) continue;
            return StringUtil.replaceFirst(content, ".", "", matcher.end(4) - 1);
        }
        return content;
    }

    private synchronized String _getNextReleaseCodeName() throws Exception {
        if (this._nextReleaseCodeName != null) {
            return this._nextReleaseCodeName;
        }
        Field codeNameField = ReleaseInfo.class.getDeclaredField("_CODE_NAME");
        codeNameField.setAccessible(true);
        this._nextReleaseCodeName = String.valueOf(codeNameField.get(null));
        return this._nextReleaseCodeName;
    }
}

