/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WhitespaceCheck
extends BaseFileCheck {
    private boolean _allowLeadingSpaces;

    public void setAllowLeadingSpaces(String allowLeadingSpaces) {
        this._allowLeadingSpaces = GetterUtil.getBoolean(allowLeadingSpaces);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._trimContent(fileName, content);
        if ((content = StringUtil.replace(content, "\n\n\n", "\n\n")).startsWith("\n")) {
            content = content.substring(1);
        }
        if (content.endsWith("\r")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String formatIncorrectSyntax(String line, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        if (ToolsUtil.isInsideQuotes(line, matcher.start(1))) {
            return line;
        }
        String whitespace = matcher.group(2);
        if (whitespace.length() > 0) {
            return line;
        }
        return line.substring(0, matcher.start(2)) + " " + line.substring(matcher.start(2));
    }

    protected String formatIncorrectSyntax(String line, String incorrectSyntax, String correctSyntax, boolean lineStart) {
        if (lineStart) {
            if (line.startsWith(incorrectSyntax)) {
                line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax);
            }
            return line;
        }
        int x = -1;
        while ((x = line.indexOf(incorrectSyntax, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax, x);
        }
        return line;
    }

    protected String formatWhitespace(String line, String linePart, boolean javaSource) {
        String linePart2;
        String originalLinePart = linePart;
        linePart = this.formatIncorrectSyntax(linePart, "catch(", "catch (", true);
        linePart = this.formatIncorrectSyntax(linePart, "else{", "else {", true);
        linePart = this.formatIncorrectSyntax(linePart, "else if(", "else if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "for(", "for (", true);
        linePart = this.formatIncorrectSyntax(linePart, "if(", "if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "while(", "while (", true);
        linePart = this.formatIncorrectSyntax(linePart, "List <", "List<", false);
        if (javaSource) {
            linePart = this.formatIncorrectSyntax(linePart, " ...", "...", false);
            linePart = this.formatIncorrectSyntax(linePart, " [", "[", false);
            linePart = this.formatIncorrectSyntax(linePart, "{ ", "{", false);
            linePart = this.formatIncorrectSyntax(linePart, " }", "}", false);
            linePart = this.formatIncorrectSyntax(linePart, " )", ")", false);
            linePart = this.formatIncorrectSyntax(linePart, "( ", "(", false);
            linePart = this.formatIncorrectSyntax(linePart, "){", ") {", false);
            linePart = this.formatIncorrectSyntax(linePart, "]{", "] {", false);
            linePart = this.formatIncorrectSyntax(linePart, "(\\.\\.\\.( ?))\\w");
            linePart = this.formatIncorrectSyntax(linePart, "\\w(( ?)=)");
            linePart = this.formatIncorrectSyntax(linePart, "(=( ?))\\w");
            linePart = this.formatIncorrectSyntax(linePart, "for \\([^:]*(( ?):)");
            linePart = this.formatIncorrectSyntax(linePart, "for \\([^:]*(:( ?)).+");
        }
        if (!linePart.startsWith("##")) {
            int x = 0;
            while ((x = linePart.indexOf("  ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
                linePart = StringUtil.replaceFirst(linePart, "  ", " ", x);
            }
        }
        if (!javaSource) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        if (!line.contains("//")) {
            while (linePart.contains("\t")) {
                linePart = StringUtil.replaceLast(linePart, "\t", " ");
            }
        }
        if (line.contains("//")) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        int pos = linePart.indexOf(") ");
        if (!(pos == -1 || pos + 2 >= linePart.length() || linePart.contains("@") || ToolsUtil.isInsideQuotes(linePart, pos) || !Character.isLetter((linePart2 = linePart.substring(pos + 2)).charAt(0)) || linePart2.startsWith("default") || linePart2.startsWith("instanceof") || linePart2.startsWith("return") || linePart2.startsWith("throws"))) {
            linePart = StringUtil.replaceFirst(linePart, " ", "", pos);
        }
        if ((pos = linePart.indexOf(" (")) != -1 && !linePart.contains("=") && !ToolsUtil.isInsideQuotes(linePart, pos) && (linePart.startsWith("private ") || linePart.startsWith("protected ") || linePart.startsWith("public "))) {
            linePart = StringUtil.replaceFirst(linePart, " (", "(", pos);
        }
        int x = -1;
        while (true) {
            char previousChar;
            char nextChar;
            int posComma = linePart.indexOf(44, x + 1);
            int posSemicolon = linePart.indexOf(59, x + 1);
            if (posComma == -1 && posSemicolon == -1) break;
            x = Math.min(posComma, posSemicolon);
            if (x == -1) {
                x = Math.max(posComma, posSemicolon);
            }
            if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
            if (linePart.length() > x + 1 && (nextChar = linePart.charAt(x + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                linePart = StringUtil.insert(linePart, " ", x + 1);
            }
            if (x <= 0 || (previousChar = linePart.charAt(x - 1)) != ' ') continue;
            linePart = linePart.substring(0, x - 1).concat(linePart.substring(x));
        }
        line = StringUtil.replace(line, originalLinePart, linePart);
        return this.formatIncorrectSyntax(line, " \t", "\t", false);
    }

    protected boolean isAllowLeadingSpaces(String fileName) {
        return this._allowLeadingSpaces;
    }

    protected boolean isAllowTrailingEmptyLines(String fileName) {
        return false;
    }

    protected String trimLine(String fileName, String line) {
        String trimmedLine = StringUtil.trim(line);
        if (trimmedLine.length() == 0) {
            return "";
        }
        line = StringUtil.trimTrailing(line);
        if (this.isAllowLeadingSpaces(fileName) || line.startsWith(" *")) {
            return line;
        }
        while (line.matches("^\t*    .*")) {
            line = StringUtil.replaceFirst(line, "    ", "\t");
        }
        while (line.startsWith(" ")) {
            line = StringUtil.replaceFirst(line, ' ', "");
        }
        return line;
    }

    private String _trimContent(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this.trimLine(fileName, line));
                sb.append("\n");
            }
        }
        if (this.isAllowTrailingEmptyLines(fileName) && content.endsWith("\n")) {
            return sb.toString();
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

