/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLDDLStructuresFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("structures.xml")) {
            this._checkDDLStructuresXML(fileName, content);
        }
        return content;
    }

    private void _checkDDLStructuresXML(String fileName, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        this.checkElementOrder(fileName, rootElement, "structure", null, new StructureElementComparator());
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            this.checkElementOrder(fileName, structureRootElement, "dynamic-element", "root", new ElementComparator());
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                this.checkElementOrder(fileName, metaDataElement, "entry", "meta-data", new ElementComparator());
            }
        }
    }

    private static class StructureElementComparator
    extends ElementComparator {
        private StructureElementComparator() {
        }

        @Override
        public String getElementName(Element element) {
            Element nameElement = element.element(this.getNameAttribute());
            return nameElement.getText();
        }
    }
}

