/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericType
implements UnionType,
PlainType {
    private static final NumericType THE_INSTANCE = new NumericType();
    private static List<PlainType> members;

    public static NumericType getInstance() {
        return THE_INSTANCE;
    }

    private NumericType() {
    }

    @Override
    public StructuredQName getTypeName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", "numeric");
    }

    @Override
    public boolean containsListType() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterable<PlainType> getPlainMemberTypes() {
        if (members != null) return members;
        Class<NumericType> clazz = NumericType.class;
        synchronized (NumericType.class) {
            members = new ArrayList<PlainType>();
            members.add(BuiltInAtomicType.DOUBLE);
            members.add(BuiltInAtomicType.FLOAT);
            members.add(BuiltInAtomicType.DECIMAL);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return members;
        }
    }

    @Override
    public SequenceType getResultTypeOfCast() {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    @Override
    public boolean isPlainType() {
        return true;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        return item instanceof NumericValue;
    }

    @Override
    public AtomicType getPrimitiveItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public int getPrimitiveType() {
        return BuiltInAtomicType.ANY_ATOMIC.getFingerprint();
    }

    @Override
    public UType getUType() {
        return UType.NUMERIC;
    }

    @Override
    public PlainType getAtomizedItemType() {
        return this;
    }

    @Override
    public boolean isAtomizable() {
        return true;
    }

    @Override
    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public boolean isExternalType() {
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return true;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public AtomicSequence getTypedValue(CharSequence value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        try {
            double d = StringToDouble.getInstance().stringToNumber(value);
            return new DoubleValue(d);
        }
        catch (NumberFormatException e) {
            throw new ValidationFailure(e.getMessage()).makeException();
        }
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules) {
        try {
            StringToDouble.getInstance().stringToNumber(value);
            return null;
        }
        catch (NumberFormatException e) {
            return new ValidationFailure(e.getMessage());
        }
    }

    @Override
    public ValidationFailure checkAgainstFacets(AtomicValue value, ConversionRules rules) {
        return null;
    }

    @Override
    public boolean isNamespaceSensitive() {
        return false;
    }

    @Override
    public int getWhitespaceAction() {
        return 2;
    }

    @Override
    public CharSequence preprocess(CharSequence input) throws ValidationException {
        return input;
    }

    @Override
    public CharSequence postprocess(CharSequence input) throws ValidationException {
        return input;
    }

    @Override
    public String getName() {
        return "numeric";
    }

    @Override
    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    @Override
    public int getFingerprint() {
        return 635;
    }

    @Override
    public String getDisplayName() {
        return "xs:numeric";
    }

    @Override
    public String getEQName() {
        return "Q(http://www.w3.org/2001/XMLSchema}numeric";
    }

    @Override
    public StructuredQName getStructuredQName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", "numeric");
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAnonymousType() {
        return false;
    }

    @Override
    public int getBlock() {
        return 0;
    }

    @Override
    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public int getDerivationMethod() {
        return 1;
    }

    @Override
    public int getFinalProhibitions() {
        return 0;
    }

    @Override
    public boolean allowsDerivation(int derivation) {
        return true;
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind) throws XPathException {
    }

    @Override
    public AtomicSequence atomize(NodeInfo node) throws XPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameType(SchemaType other) {
        return other instanceof NumericType;
    }

    @Override
    public String getDescription() {
        return "xs:numeric";
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType base, int block) throws SchemaException {
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return false;
    }

    @Override
    public int getValidationStatus() {
        return 3;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    public Function getComponentAsFunction() {
        return null;
    }

    public String toString() {
        return "xs:numeric";
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) {
        if (targetVersion == 1) {
            return "return SaxonJS.U.Atomic.numeric.matches(item);";
        }
        return "return SaxonJS.U.isNumeric(item);";
    }

    @Override
    public String generateJavaScriptItemTypeAcceptor(String errorCode, int targetVersion) throws XPathException {
        return BuiltInAtomicType.DOUBLE.generateJavaScriptItemTypeAcceptor(errorCode, targetVersion);
    }
}

