/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;

public class JavaWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatWhitespace(fileName, content);
        content = StringUtil.replace(content, "\n\n\n", "\n\n");
        return content;
    }

    private String _formatWhitespace(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int previousLineLeadingTabCount;
                int lineLeadingTabCount;
                String trimmedLine = StringUtil.trimLeading(line = this.trimLine(fileName, line));
                if (trimmedLine.startsWith("*\t")) {
                    line = StringUtil.replaceFirst(line, "*\t", "* ");
                }
                if (trimmedLine.startsWith("//") || trimmedLine.startsWith("*")) {
                    sb.append(line);
                    sb.append("\n");
                    previousLine = line;
                    continue;
                }
                if (!(!line.contains("\t ") || previousLine.matches(".*[&|^]") || previousLine.contains("\t((") || previousLine.contains("\t<") || previousLine.contains("\t ") || previousLine.contains("\tfor (") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                    line = StringUtil.replace(line, "\t ", "\t");
                }
                line = this.formatIncorrectSyntax(line, ",}", "}", false);
                line = this.formatWhitespace(line, trimmedLine, true);
                if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                    line = StringUtil.replaceLast(line, '{', " {");
                }
                if ((lineLeadingTabCount = this.getLeadingTabCount(line)) - 2 == (previousLineLeadingTabCount = this.getLeadingTabCount(previousLine)) && previousLineLeadingTabCount > 0 && line.endsWith(";") && !previousLine.contains("\tfor (") && !previousLine.contains("\ttry (")) {
                    line = StringUtil.replaceFirst(line, '\t', "");
                }
                sb.append(line);
                sb.append("\n");
                previousLine = line;
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

