/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceAroundGenericsCheck
extends BaseCheck {
    private static final String _MSG_MISSING_WHITESPACE = "whitespace.missing";
    private static final String _MSG_REDUNDANT_WHITESPACE = "whitespace.redundant";

    public int[] getDefaultTokens() {
        return new int[]{173, 172};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (!DetailASTUtil.hasParentWithTokenType(detailAST, 13)) {
            return;
        }
        String line = this.getLine(detailAST.getLineNo() - 1);
        if (detailAST.getType() == 173) {
            if (detailAST.getColumnNo() + 1 >= line.length()) {
                return;
            }
            char c = line.charAt(detailAST.getColumnNo() + 1);
            if (c != ')' && c != ',' && c != '.' && c != '>' && c != '[' && c != ' ') {
                this.log(detailAST.getLineNo(), _MSG_MISSING_WHITESPACE, new Object[]{detailAST.getText()});
            }
        } else {
            char c = line.charAt(detailAST.getColumnNo() - 1);
            if (c == ' ') {
                this.log(detailAST.getLineNo(), _MSG_REDUNDANT_WHITESPACE, new Object[]{detailAST.getText()});
            }
        }
    }
}

