/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};
    private Map<String, String> _portalModulesBundleVersionsMap;

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        file = super.format(file, fileName, absolutePath, content);
        this._processPortalModulesBundleVersion(absolutePath, content);
        return file;
    }

    @Override
    protected void postFormat() throws IOException {
        this._processPortalModulesBundleVersions();
    }

    @Override
    protected void preFormat() throws IOException {
        this._initPortalModulesVersionsMap();
    }

    private boolean _checkModulesPropertiesFile() {
        if (!this.isPortalSource()) {
            return false;
        }
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        List<String> fileExtensions = sourceFormatterArgs.getFileExtensions();
        return fileExtensions.contains("bnd");
    }

    private String _getBundleSymbolicName(String absolutePath, String content) {
        if (absolutePath.endsWith("/portal-impl/bnd.bnd")) {
            return "com.liferay.portal.impl";
        }
        if (absolutePath.endsWith("/portal-kernel/bnd.bnd")) {
            return "com.liferay.portal.kernel";
        }
        if (absolutePath.endsWith("/portal-test-integration/bnd.bnd")) {
            return "com.liferay.portal.test.integration";
        }
        if (absolutePath.endsWith("/portal-test/bnd.bnd")) {
            return "com.liferay.portal.test";
        }
        if (absolutePath.endsWith("/portal-support-tomcat/bnd.bnd")) {
            return "com.liferay.support.tomcat";
        }
        if (absolutePath.endsWith("/util-bridges/bnd.bnd")) {
            return "com.liferay.util.bridges";
        }
        if (absolutePath.endsWith("/util-java/bnd.bnd")) {
            return "com.liferay.util.java";
        }
        if (absolutePath.endsWith("/util-slf4j/bnd.bnd")) {
            return "com.liferay.util.slf4j";
        }
        if (absolutePath.endsWith("/util-taglib/bnd.bnd")) {
            return "com.liferay.util.taglib";
        }
        return BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
    }

    private void _initPortalModulesVersionsMap() throws IOException {
        this._portalModulesBundleVersionsMap = new TreeMap<String, String>();
        if (!this._checkModulesPropertiesFile()) {
            return;
        }
        File modulesPropertiesFile = new File(this.getPortalDir(), "modules/modules.properties");
        if (!modulesPropertiesFile.exists()) {
            return;
        }
        String content = FileUtil.read(modulesPropertiesFile);
        for (String line : StringUtil.splitLines(content)) {
            String[] array = StringUtil.split(line, "=");
            if (array.length != 2) continue;
            this._portalModulesBundleVersionsMap.put(array[0], array[1]);
        }
    }

    private synchronized void _processPortalModulesBundleVersion(String absolutePath, String content) {
        if (!this._checkModulesPropertiesFile()) {
            return;
        }
        if (!absolutePath.endsWith("/bnd.bnd") || absolutePath.contains("/private/") || absolutePath.contains("/test/") || absolutePath.contains("/test-integration/")) {
            return;
        }
        String bundleSymbolicName = this._getBundleSymbolicName(absolutePath, content);
        if (Validator.isNull(bundleSymbolicName)) {
            return;
        }
        if (!bundleSymbolicName.startsWith("com.liferay.")) {
            return;
        }
        String bundleVersion = BNDSourceUtil.getDefinitionValue(content, "Bundle-Version");
        if (Validator.isNull(bundleVersion)) {
            return;
        }
        this._portalModulesBundleVersionsMap.put(bundleSymbolicName, bundleVersion);
    }

    private void _processPortalModulesBundleVersions() throws IOException {
        String oldContent;
        if (!this._checkModulesPropertiesFile()) {
            return;
        }
        ArrayList<String> modulesProperties = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this._portalModulesBundleVersionsMap.entrySet()) {
            modulesProperties.add(entry.getKey() + "=" + entry.getValue());
        }
        File modulesPropertiesFile = new File(this.getPortalDir(), "modules/modules.properties");
        String newContent = StringUtil.merge(modulesProperties, "\n");
        if (!newContent.equals(oldContent = FileUtil.read(modulesPropertiesFile))) {
            FileUtil.write(modulesPropertiesFile, newContent);
            System.out.println("Updated 'modules.properties'");
        }
    }
}

