/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSImportsCheck
extends BaseFileCheck {
    private final Pattern _importsPattern = Pattern.compile("(@import \".*\";(\n|\\Z))+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._importsPattern.matcher(content);
        while (matcher.find()) {
            String imports = StringUtil.trim(matcher.group());
            Object[] lines = StringUtil.splitLines(imports);
            Arrays.sort(lines);
            StringBundler sb = new StringBundler(lines.length * 2);
            for (Object line : lines) {
                sb.append((String)line);
                sb.append("\n");
            }
            sb.setIndex(sb.index() - 1);
            String newImports = sb.toString();
            if (imports.equals(newImports)) continue;
            return StringUtil.replaceFirst(content, imports, newImports, matcher.start());
        }
        return content;
    }
}

