/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class GradlePropertiesCheck
extends BaseFileCheck {
    private static final String[] _KEYS_WITH_QUOTED_VALUE = new String[]{"sourceCompatibility", "targetCompatibility"};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] array = line.split("=", 2);
                if (array.length == 2) {
                    String key = array[0].trim();
                    String value = array[1].trim();
                    if (ArrayUtil.contains(_KEYS_WITH_QUOTED_VALUE, key)) {
                        String strippedValue = StringUtil.removeChars(value, '\'', '\"');
                        line = StringUtil.replaceLast(line, value, "\"" + strippedValue + "\"");
                    }
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

