/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageinfoBNDExportPackageCheck
extends BaseFileCheck {
    private final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _exportPackagePattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/src/main/resources/") && !this._hasBNDExportPackage(fileName)) {
            return null;
        }
        return content;
    }

    private List<String> _getBNDExportPackages(String fileName) throws IOException {
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return Collections.emptyList();
        }
        Matcher matcher = this._exportPackagePattern.matcher(bndSettings.getContent());
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> exportPackages = new ArrayList<String>();
        for (String line : StringUtil.splitLines(matcher.group(3))) {
            if (Validator.isNull(line = StringUtil.trim(line)) || line.equals("\\")) continue;
            if ((line = StringUtil.removeSubstring(line, ",\\")).indexOf(";") != -1) {
                line = line.substring(0, line.indexOf(";"));
            }
            exportPackages.add(line.replace('.', '/'));
        }
        matcher = this._exportContentsPattern.matcher(bndSettings.getContent());
        if (!matcher.find()) {
            return exportPackages;
        }
        for (String line : StringUtil.splitLines(matcher.group(3))) {
            if (Validator.isNull(line = StringUtil.trim(line)) || line.equals("\\")) continue;
            if ((line = StringUtil.removeSubstring(line, ",\\")).indexOf(";") != -1) {
                line = line.substring(0, line.indexOf(";"));
            }
            exportPackages.add(line.replace('.', '/'));
        }
        return exportPackages;
    }

    private boolean _hasBNDExportPackage(String fileName) throws IOException {
        List<String> bndExportPackages = this._getBNDExportPackages(fileName);
        for (String bndExportPackage : bndExportPackages) {
            String suffix = "/src/main/resources/" + bndExportPackage + "/packageinfo";
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

