/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import com.liferay.source.formatter.checks.util.YMLSourceUtil;
import java.io.IOException;
import java.util.List;

public class YMLWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = StringUtil.replace(content, '\t', "    ");
        content = this._checkDefinitions(content, "", 0);
        return super.doProcess(fileName, absolutePath, content);
    }

    private String _checkDefinitions(String content, String indent, int level) {
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        for (String definition : definitions) {
            String[] lines;
            String nestedDefinitionIndent;
            String expectedIndent = "";
            for (int i = 0; i < level; ++i) {
                expectedIndent = expectedIndent + "    ";
            }
            if (!indent.equals(expectedIndent)) {
                content = StringUtil.replaceFirst(content, definition, expectedIndent + StringUtil.trimLeading(definition));
            }
            if ((nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition)).equals("")) continue;
            List<String> nestedDefinitions = YMLSourceUtil.getDefinitions(definition, nestedDefinitionIndent);
            String newDefinition = this._checkDefinitions(definition, nestedDefinitionIndent, level + 1);
            if (newDefinition.equals(definition) && nestedDefinitions.isEmpty() && (lines = StringUtil.splitLines(newDefinition)).length > 1) {
                expectedIndent = expectedIndent + "    ";
                for (int i = 1; i < lines.length; ++i) {
                    String line = lines[i];
                    String expectedLine = expectedIndent + StringUtil.trimLeading(line);
                    if (line.equals(expectedLine)) continue;
                    newDefinition = StringUtil.replaceFirst(newDefinition, line, expectedLine);
                }
            }
            if (newDefinition.equals(definition)) continue;
            content = StringUtil.replaceFirst(content, definition, newDefinition);
        }
        return content;
    }
}

