/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ParsePrimitiveTypeCheck
extends BaseCheck {
    private static final String _MSG_USE_GETTER_UTIL_METHOD = "getter.util.method.use";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this.isRunOutsidePortalExclude()) {
            return;
        }
        this._checkParseMethodCall(detailAST, "Double", "parseDouble", "getDouble");
        this._checkParseMethodCall(detailAST, "Float", "parseFloat", "getFloat");
        this._checkParseMethodCall(detailAST, "Integer", "parseInt", "getInteger");
        this._checkParseMethodCall(detailAST, "Long", "parseLong", "getLong");
        this._checkParseMethodCall(detailAST, "Short", "parseShort", "getShort");
    }

    /*
     * Unable to fully structure code
     */
    private boolean _catchesException(DetailAST methodCallAST, String ... exceptionNames) {
        parentAST = methodCallAST.getParent();
        block0: while (true) {
            if (parentAST == null) {
                return false;
            }
            if (parentAST.getType() != 95) {
                parentAST = parentAST.getParent();
                continue;
            }
            literalCatchAST = parentAST.findFirstToken(96);
            parentAST = parentAST.getParent();
            if (literalCatchAST == null) continue;
            parameterDefAST = literalCatchAST.findFirstToken(21);
            typeAST = parameterDefAST.findFirstToken(13);
            identASTList = DetailASTUtil.getAllChildTokens(typeAST, true, new int[]{58});
            var8_8 = identASTList.iterator();
            do {
                if (var8_8.hasNext()) ** break;
                continue block0;
            } while (!ArrayUtil.contains(exceptionNames, (identAST = var8_8.next()).getText()));
            break;
        }
        return true;
    }

    private void _checkParseMethodCall(DetailAST detailAST, String className, String methodName, String getterUtilMethodName) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST elistAST = methodCallAST.findFirstToken(34);
            List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elistAST, false, 28);
            if (exprASTList.size() != 1 || this._catchesException(methodCallAST, "Exception", "NumberFormatException")) continue;
            this.log(methodCallAST.getLineNo(), _MSG_USE_GETTER_UTIL_METHOD, new Object[]{getterUtilMethodName, className, methodName});
        }
    }
}

