/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class MapIterationCheck
extends BaseCheck {
    private static final String _MSG_USE_ENTRY_SET = "entry.set.use";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> forEachClauseASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 156);
        for (DetailAST forEachClauseAST : forEachClauseASTList) {
            this._checkKeySetIteration(forEachClauseAST);
        }
    }

    private void _checkKeySetIteration(DetailAST forEachClauseAST) {
        DetailAST variableDefAST = forEachClauseAST.findFirstToken(10);
        DetailAST identAST = variableDefAST.findFirstToken(58);
        String keyName = identAST.getText();
        List<DetailAST> keySetMethodCallASTList = DetailASTUtil.getMethodCalls(forEachClauseAST, "keySet");
        for (DetailAST keySetMethodCallAST : keySetMethodCallASTList) {
            List<DetailAST> wildcardTypeASTList;
            DetailAST typeAST;
            FullIdent fullIdent = FullIdent.createFullIdentBelow((DetailAST)keySetMethodCallAST);
            String mapName = StringUtil.replaceLast(fullIdent.getText(), ".keySet", "");
            if (!this._containsGetMethod(forEachClauseAST.getParent(), keyName, mapName) || (typeAST = DetailASTUtil.getVariableTypeAST(keySetMethodCallAST, mapName)) == null || !DetailASTUtil.isCollection(typeAST) || !(wildcardTypeASTList = DetailASTUtil.getAllChildTokens(typeAST, true, 167)).isEmpty()) continue;
            this.log(forEachClauseAST.getLineNo(), _MSG_USE_ENTRY_SET, new Object[0]);
        }
    }

    private boolean _containsGetMethod(DetailAST forAST, String keyName, String mapName) {
        List<DetailAST> getMethodCallASTList = DetailASTUtil.getMethodCalls(forAST, mapName, "get");
        for (DetailAST getMethodCallAST : getMethodCallASTList) {
            String parameterName;
            DetailAST eListAST = getMethodCallAST.findFirstToken(34);
            DetailAST firstChildAST = eListAST.getFirstChild();
            if (firstChildAST.getType() != 28 || (firstChildAST = firstChildAST.getFirstChild()).getType() != 58 || !(parameterName = firstChildAST.getText()).equals(keyName)) continue;
            return true;
        }
        return false;
    }
}

