/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleVersionCheck
extends BaseFileCheck {
    private final Pattern _bndConditionalPackagePattern = Pattern.compile("-conditionalpackage:(.*[^\\\\])(\n|\\Z)", 32);
    private final Pattern _versionPattern = Pattern.compile("\n\t*(.* name: \"(.*?)\", version: \"(.*?)\")");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        Matcher matcher = this._versionPattern.matcher(content);
        while (matcher.find()) {
            String name = matcher.group(2);
            String version = matcher.group(3);
            this._checkDefaultVersion(fileName, content, name, version, matcher.start());
            if (!this.isSubrepository() && !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/private/apps/") || this._isTestUtilModule(absolutePath)) continue;
            content = this._fixMicroVersion(fileName, content, matcher.group(1), name, version);
        }
        return content;
    }

    private void _checkDefaultVersion(String fileName, String content, String name, String version, int pos) {
        if (!(!version.equals("default") || name.equals("com.liferay.portal.impl") || name.equals("com.liferay.portal.kernel") || name.equals("com.liferay.portal.test") || name.equals("com.liferay.portal.test.integration") || name.equals("com.liferay.util.bridges") || name.equals("com.liferay.util.java") || name.equals("com.liferay.util.taglib"))) {
            this.addMessage(fileName, "Do not use 'default' version for '" + name + "'", "gradle_versioning.markdown", this.getLineNumber(content, pos));
        }
    }

    private String _fixMicroVersion(String fileName, String content, String line, String name, String version) throws IOException {
        String conditionalPackageContent;
        String bndFileContent;
        Matcher matcher;
        if (!line.startsWith("compileOnly ") && !line.startsWith("provided ")) {
            return content;
        }
        if (!name.startsWith("com.liferay.") || !version.matches("[0-9]+\\.[0-9]+\\.[1-9][0-9]*")) {
            return content;
        }
        int pos = fileName.lastIndexOf(47);
        String bndFileLocation = fileName.substring(0, pos + 1) + "bnd.bnd";
        File bndFile = new File(bndFileLocation);
        if (bndFile.exists() && (matcher = this._bndConditionalPackagePattern.matcher(bndFileContent = FileUtil.read(bndFile))).find() && (conditionalPackageContent = matcher.group()).contains(name)) {
            return content;
        }
        pos = version.lastIndexOf(".");
        String newLine = StringUtil.replaceFirst(line, "version: \"" + version + "\"", "version: \"" + version.substring(0, pos + 1) + "0\"");
        return StringUtil.replaceFirst(content, line, newLine);
    }

    private boolean _isTestUtilModule(String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        return moduleName.endsWith("-test-util");
    }
}

