/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesBuildIncludeDirsCheck
extends BaseFileCheck {
    private static final String[] _SKIP_DIR_NAMES = new String[]{".git", ".gradle", ".idea", ".m2", ".settings", "bin", "build", "classes", "dependencies", "node_modules", "private", "sql", "src", "test", "test-classes", "test-coverage", "test-results", "tmp"};
    private Set<String> _buildIncludeDirs;
    private final Pattern _pattern = Pattern.compile("([^\\S\\n]*)#build\\.include\\.dirs=\\\\(\\s*#.*)*");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/build.properties")) {
            return content;
        }
        Matcher matcher = this._pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        StringBundler sb = new StringBundler();
        sb.append(matcher.group(1));
        sb.append("#build.include.dirs=\\");
        sb.append("\n");
        Set<String> buildIncludeDirs = this._getBuildIncludeDirs();
        for (String buildIncludeDir : buildIncludeDirs) {
            sb.append(matcher.group(1));
            sb.append("#");
            sb.append("    ");
            sb.append(buildIncludeDir);
            sb.append(",\\");
            sb.append("\n");
        }
        if (!buildIncludeDirs.isEmpty()) {
            sb.setIndex(sb.index() - 2);
        }
        return StringUtil.replaceFirst(content, matcher.group(), sb.toString());
    }

    private synchronized Set<String> _getBuildIncludeDirs() throws IOException {
        if (this._buildIncludeDirs != null) {
            return this._buildIncludeDirs;
        }
        File modulesDir = new File(this.getPortalDir(), "modules");
        final TreeSet<String> buildIncludeDirs = new TreeSet<String>();
        Files.walkFileTree(modulesDir.toPath(), EnumSet.noneOf(FileVisitOption.class), 15, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ArrayUtil.contains(_SKIP_DIR_NAMES, dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path path = dirPath.resolve(".lfrbuild-portal");
                if (!Files.exists(path, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                String absolutePath = SourceUtil.getAbsolutePath(dirPath);
                int x = absolutePath.indexOf("/modules/");
                if (x != -1) {
                    String dir = absolutePath.substring(x + 9);
                    int y = absolutePath.indexOf("/", x + 9);
                    if (y != -1 && (y = absolutePath.indexOf("/", y + 1)) != -1) {
                        dir = absolutePath.substring(x + 9, y);
                    }
                    buildIncludeDirs.add(dir);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        this._buildIncludeDirs = buildIncludeDirs;
        return this._buildIncludeDirs;
    }
}

