/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class TLDElementOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        this._checkElementOrder(fileName, content);
        return content;
    }

    private void _checkElementOrder(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List tagElements = rootElement.elements("tag");
        for (Element tagElement : tagElements) {
            Element nameElement = tagElement.element("name");
            this.checkElementOrder(fileName, tagElement, "attribute", nameElement.getText(), new TagElementComparator());
        }
        this.checkElementOrder(fileName, rootElement, "tag", null, new TagElementComparator());
    }

    private static class TagElementComparator
    extends ElementComparator {
        private TagElementComparator() {
        }

        @Override
        public String getElementName(Element element) {
            Element nameElement = element.element(this.getNameAttribute());
            return nameElement.getText();
        }
    }
}

