/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TLDTypeCheck
extends BaseFileCheck {
    private static final Pattern _typePattern = Pattern.compile("\n\t*<type>(.*)</type>\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatTypes(fileName, content);
        return content;
    }

    private String _formatTypes(String fileName, String content) {
        Matcher matcher = _typePattern.matcher(content);
        while (matcher.find()) {
            String typeName = matcher.group(1);
            if (typeName.matches("[A-Z]\\w*")) {
                this.addMessage(fileName, "Use fully qualified class name, see LPS-61841", this.getLineNumber(content, matcher.start(1)));
                continue;
            }
            if (!typeName.equals("java.lang.String")) continue;
            return StringUtil.replaceFirst(content, matcher.group(), "\n");
        }
        return content;
    }
}

