/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.YMLSourceUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLDefinitionOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._sortDefinitions(fileName, content, "");
    }

    private String _sortDefinitions(String fileName, String content, String indent) {
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        DefinitionComparator definitionComparator = new DefinitionComparator(fileName);
        for (int i = 1; i < definitions.size(); ++i) {
            String newDefinition;
            String definition = definitions.get(i);
            String previousDefinition = definitions.get(i - 1);
            if (definitionComparator.compare(previousDefinition, definition) > 0) {
                definition = StringUtil.trimTrailing(definition);
                previousDefinition = StringUtil.trimTrailing(previousDefinition);
                content = StringUtil.replaceFirst(content, previousDefinition, definition);
                return StringUtil.replaceLast(content, definition, previousDefinition);
            }
            String nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition);
            if (!nestedDefinitionIndent.equals("") && !(newDefinition = this._sortDefinitions(fileName, definition, nestedDefinitionIndent)).equals(definition)) {
                return StringUtil.replaceFirst(content, definition, newDefinition);
            }
            nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(previousDefinition);
            if (nestedDefinitionIndent.equals("") || (newDefinition = this._sortDefinitions(fileName, previousDefinition, nestedDefinitionIndent)).equals(previousDefinition)) continue;
            return StringUtil.replaceFirst(content, previousDefinition, newDefinition);
        }
        return content;
    }

    private static class DefinitionComparator
    implements Comparator<String>,
    Serializable {
        private static final Map<String, Integer> _travisDefinitionKeyWeightMap = new HashMap<String, Integer>();
        private final Pattern _definitionKeyPattern = Pattern.compile("(.*?):");
        private final String _fileName;

        public DefinitionComparator(String fileName) {
            this._fileName = fileName;
        }

        @Override
        public int compare(String definition1, String definition2) {
            String definitionKey1 = this._getDefinitionKey(definition1);
            String definitionKey2 = this._getDefinitionKey(definition2);
            if (this._fileName.endsWith("/.travis.yml")) {
                int weight1 = this._getTravisDefinitionKeyWeight(definitionKey1);
                int weight2 = this._getTravisDefinitionKeyWeight(definitionKey2);
                if (weight1 != -1 || weight2 != -1) {
                    return weight1 - weight2;
                }
            }
            return definitionKey1.compareTo(definitionKey2);
        }

        private String _getDefinitionKey(String definition) {
            Matcher matcher = this._definitionKeyPattern.matcher(definition);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return definition;
        }

        private int _getTravisDefinitionKeyWeight(String definitionKey) {
            if (_travisDefinitionKeyWeightMap.containsKey(definitionKey)) {
                return _travisDefinitionKeyWeightMap.get(definitionKey);
            }
            return -1;
        }

        static {
            _travisDefinitionKeyWeightMap.put("after_deploy", 11);
            _travisDefinitionKeyWeightMap.put("after_failure", 8);
            _travisDefinitionKeyWeightMap.put("after_script", 12);
            _travisDefinitionKeyWeightMap.put("after_success", 7);
            _travisDefinitionKeyWeightMap.put("before_cache", 5);
            _travisDefinitionKeyWeightMap.put("before_deploy", 9);
            _travisDefinitionKeyWeightMap.put("before_install", 1);
            _travisDefinitionKeyWeightMap.put("before_script", 3);
            _travisDefinitionKeyWeightMap.put("cache", 6);
            _travisDefinitionKeyWeightMap.put("deploy", 10);
            _travisDefinitionKeyWeightMap.put("install", 2);
            _travisDefinitionKeyWeightMap.put("script", 4);
        }
    }
}

