/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.source.formatter.checkstyle.checks.BaseEnumConstantCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EnumConstantOrderCheck
extends BaseEnumConstantCheck {
    private static final String _MSG_ENUM_CONSTANT_ORDER_INCORRECT = "enum.constant.incorrect.order";

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST nextEnumConstantDefAST = this.getNextEnumConstantDefAST(detailAST);
        if (nextEnumConstantDefAST != null) {
            this._checkOrder(detailAST, nextEnumConstantDefAST);
        }
    }

    private void _checkOrder(DetailAST enumConstantDefAST1, DetailAST enumConstantDefAST2) {
        String name2;
        NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
        String name1 = this._getName(enumConstantDefAST1);
        if (comparator.compare(name1, name2 = this._getName(enumConstantDefAST2)) > 0) {
            this.log(enumConstantDefAST1.getLineNo(), _MSG_ENUM_CONSTANT_ORDER_INCORRECT, new Object[]{name1, name2});
        }
    }

    private String _getName(DetailAST enumConstantDefAST) {
        DetailAST nameAST = enumConstantDefAST.findFirstToken(58);
        return nameAST.getText();
    }
}

