/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class MissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_CALL = "empty.line.missing.after.method.call";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE = "empty.line.missing.after.variable.reference";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE = "empty.line.missing.before.variable.use";

    public int[] getDefaultTokens() {
        return new int[]{80, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 27) {
            this._checkMissingEmptyLineAfterMethodCall(detailAST);
            return;
        }
        DetailAST firstChildAST = detailAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() == 59) {
            return;
        }
        String variableName = this._getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        this._checkMissingEmptyLineAfterReferencingVariable(parentAST, variableName, DetailASTUtil.getEndLine(detailAST));
        this._checkMissingEmptyLineBetweenAssigningAndUsingVariable(parentAST, variableName, DetailASTUtil.getEndLine(detailAST));
    }

    private void _checkMissingEmptyLineAfterMethodCall(DetailAST detailAST) {
        DetailAST firstChildAST;
        int startLineNextExpression;
        String variableName = DetailASTUtil.getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getType() != 28) {
            return;
        }
        DetailAST nextSiblingAST = parentAST.getNextSibling();
        if (nextSiblingAST == null || nextSiblingAST.getType() != 45) {
            return;
        }
        if ((nextSiblingAST = nextSiblingAST.getNextSibling()) == null) {
            return;
        }
        int endLine = DetailASTUtil.getEndLine(detailAST);
        if (endLine + 1 != (startLineNextExpression = DetailASTUtil.getStartLine(nextSiblingAST))) {
            return;
        }
        if (nextSiblingAST.getType() == 28 && (firstChildAST = nextSiblingAST.getFirstChild()).getType() == 27 && variableName.equals(DetailASTUtil.getVariableName(firstChildAST))) {
            return;
        }
        if (this._containsVariableName(nextSiblingAST, variableName)) {
            this.log(endLine, _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_CALL, new Object[]{endLine});
        }
    }

    private void _checkMissingEmptyLineAfterReferencingVariable(DetailAST detailAST, String variableName, int endLine) {
        String lastAssignedVariableName = null;
        DetailAST previousAST = null;
        boolean referenced = false;
        DetailAST nextSiblingAST = detailAST.getNextSibling();
        while (nextSiblingAST != null && nextSiblingAST.getType() == 45) {
            if ((nextSiblingAST = nextSiblingAST.getNextSibling()) == null || nextSiblingAST.getType() != 28 && nextSiblingAST.getType() != 10) {
                return;
            }
            if (!this._containsVariableName(nextSiblingAST, variableName)) {
                if (!referenced) {
                    return;
                }
                int startLineNextExpression = DetailASTUtil.getStartLine(nextSiblingAST);
                if (endLine + 1 != startLineNextExpression) {
                    return;
                }
                if (this._containsVariableName(previousAST, lastAssignedVariableName) && this._containsVariableName(nextSiblingAST, lastAssignedVariableName)) {
                    return;
                }
                this.log(startLineNextExpression, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE, new Object[]{startLineNextExpression, variableName});
                return;
            }
            List<DetailAST> assignASTList = DetailASTUtil.getAllChildTokens(nextSiblingAST, false, 80);
            if (assignASTList.size() == 1) {
                lastAssignedVariableName = this._getVariableName(assignASTList.get(0));
            }
            referenced = true;
            endLine = DetailASTUtil.getEndLine(nextSiblingAST);
            previousAST = nextSiblingAST;
            nextSiblingAST = nextSiblingAST.getNextSibling();
        }
        return;
    }

    private void _checkMissingEmptyLineBetweenAssigningAndUsingVariable(DetailAST detailAST, String name, int endLine) {
        DetailAST nextSiblingAST = detailAST.getNextSibling();
        if (nextSiblingAST == null || nextSiblingAST.getType() != 45) {
            return;
        }
        if ((nextSiblingAST = nextSiblingAST.getNextSibling()) == null) {
            return;
        }
        int startLineNextExpression = DetailASTUtil.getStartLine(nextSiblingAST);
        if (endLine + 1 != startLineNextExpression) {
            return;
        }
        if (this._isExpressionAssignsVariable(nextSiblingAST, name)) {
            return;
        }
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSiblingAST, true, 58);
        for (DetailAST identAST : identASTList) {
            String identName = identAST.getText();
            if (!identName.equals(name)) continue;
            this.log(startLineNextExpression, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE, new Object[]{name});
        }
    }

    private boolean _containsVariableName(DetailAST detailAST, String variableName) {
        if (variableName == null) {
            return false;
        }
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST identAST : identASTList) {
            String identName = identAST.getText();
            if (!identName.equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private String _getVariableName(DetailAST assignAST) {
        DetailAST nameAST = null;
        DetailAST parentAST = assignAST.getParent();
        if (parentAST.getType() == 28) {
            nameAST = assignAST.findFirstToken(58);
        } else if (parentAST.getType() == 10) {
            nameAST = parentAST.findFirstToken(58);
        }
        if (nameAST != null) {
            return nameAST.getText();
        }
        return null;
    }

    private boolean _isExpressionAssignsVariable(DetailAST detailAST, String name) {
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST childAST = detailAST.getFirstChild();
        if (childAST.getType() != 80) {
            return false;
        }
        DetailAST expressionNameAST = childAST.findFirstToken(58);
        if (expressionNameAST == null) {
            return false;
        }
        String expressionName = expressionNameAST.getText();
        return expressionName.equals(name);
    }
}

