/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StylingCheck
extends BaseFileCheck {
    private final Pattern _booleanPattern = Pattern.compile("\\((\\!)?(\\w+)\\s+(==|!=)\\s+(false|true)\\)");

    protected String formatStyling(String content) {
        content = this._formatStyling(content, "!Validator.isNotNull(", "Validator.isNull(");
        content = this._formatStyling(content, "!Validator.isNull(", "Validator.isNotNull(");
        content = this._formatStyling(content, "\nfor (;;) {", "\nwhile (true) {");
        content = this._formatStyling(content, "\tfor (;;) {", "\twhile (true) {");
        content = this._formatStyling(content, "String.valueOf(false)", "Boolean.FALSE.toString()");
        content = this._formatStyling(content, "String.valueOf(true)", "Boolean.TRUE.toString()");
        content = this._formatToStringMethodCall(content, "Double");
        content = this._formatToStringMethodCall(content, "Float");
        content = this._formatToStringMethodCall(content, "Integer");
        content = this._formatToStringMethodCall(content, "Long");
        content = this._formatToStringMethodCall(content, "Objects");
        content = this._formatToStringMethodCall(content, "Short");
        content = this._fixBooleanStatement(content);
        return content;
    }

    protected boolean isJavaSource(String content, int pos) {
        return true;
    }

    private String _fixBooleanStatement(String content) {
        Matcher matcher = this._booleanPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            boolean booleanValue = true;
            if (matcher.group(1) != null) {
                boolean bl = booleanValue = !booleanValue;
            }
            if (Objects.equals(matcher.group(3), "!=")) {
                boolean bl = booleanValue = !booleanValue;
            }
            if (Objects.equals(matcher.group(4), "false")) {
                boolean bl = booleanValue = !booleanValue;
            }
            if (booleanValue) {
                return StringUtil.replaceFirst(content, matcher.group(), "(" + matcher.group(2) + ")");
            }
            return StringUtil.replaceFirst(content, matcher.group(), "(!" + matcher.group(2) + ")");
        }
        return content;
    }

    private String _formatStyling(String content, String incorrectStyling, String correctStyling) {
        int x = -1;
        do {
            if ((x = content.indexOf(incorrectStyling, x + 1)) != -1) continue;
            return content;
        } while (Character.isLetterOrDigit(incorrectStyling.charAt(0)) && Character.isLetterOrDigit(content.charAt(x - 1)) || !this.isJavaSource(content, x));
        return StringUtil.replaceFirst(content, incorrectStyling, correctStyling);
    }

    private String _formatToStringMethodCall(String content, String className) {
        Pattern pattern = Pattern.compile(StringBundler.concat("\\W", className, "\\.toString\\((.*?)\\);\n"), 32);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            int pos = matcher.start();
            if (!this.isJavaSource(content, pos) || (parameterList = JavaSourceUtil.getParameterList(matcher.group())).size() != 1) continue;
            return StringUtil.replaceFirst(content, className + ".toString(", "String.valueOf(", pos);
        }
        return content;
    }
}

