/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLProjectElementCheck
extends BaseFileCheck {
    private final Pattern _pattern = Pattern.compile("\\s*\\S*\\s*=\\s*\"[^\"]*\"");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith(".pom")) {
            return content;
        }
        String[] lines = StringUtil.splitLines(content);
        if (lines.length == 0) {
            return content;
        }
        String firstLine = lines[0];
        if (!firstLine.matches("\\s*<project.*>\\s*")) {
            return content;
        }
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = this._pattern.matcher(firstLine);
        while (matcher.find()) {
            list.add(StringUtil.trim(matcher.group()));
        }
        if (list.isEmpty()) {
            return content;
        }
        list.add(0, "<project");
        list.add(">");
        return StringUtil.replaceFirst(content, firstLine, StringUtil.merge(list, "\n\t"));
    }
}

