/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BNDSourceProcessor;
import com.liferay.source.formatter.CQLSourceProcessor;
import com.liferay.source.formatter.CSSSourceProcessor;
import com.liferay.source.formatter.CodeownersSourceProcessor;
import com.liferay.source.formatter.ConfigSourceProcessor;
import com.liferay.source.formatter.DTDSourceProcessor;
import com.liferay.source.formatter.DockerfileSourceProcessor;
import com.liferay.source.formatter.ExcludeSyntax;
import com.liferay.source.formatter.ExcludeSyntaxPattern;
import com.liferay.source.formatter.FTLSourceProcessor;
import com.liferay.source.formatter.GradleSourceProcessor;
import com.liferay.source.formatter.GroovySourceProcessor;
import com.liferay.source.formatter.HTMLSourceProcessor;
import com.liferay.source.formatter.JSONSourceProcessor;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JSSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.LFRBuildSourceProcessor;
import com.liferay.source.formatter.MarkdownSourceProcessor;
import com.liferay.source.formatter.PackageinfoSourceProcessor;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.SHSourceProcessor;
import com.liferay.source.formatter.SQLSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.SoySourceProcessor;
import com.liferay.source.formatter.TLDSourceProcessor;
import com.liferay.source.formatter.TSSourceProcessor;
import com.liferay.source.formatter.XMLSourceProcessor;
import com.liferay.source.formatter.YMLSourceProcessor;
import com.liferay.source.formatter.checks.configuration.ConfigurationLoader;
import com.liferay.source.formatter.checks.configuration.SourceCheckConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.checks.configuration.SuppressionsLoader;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.dom4j.DocumentException;

public class SourceFormatter {
    public static final ExcludeSyntaxPattern[] DEFAULT_EXCLUDE_SYNTAX_PATTERNS = new ExcludeSyntaxPattern[]{new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.git/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.gradle/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/bin/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/build/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/liferay-theme.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/npm-shrinkwrap.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/package-lock.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-coverage/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-results/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/tmp/**"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, "^((?!/frontend-js-node-shims/src/).)*/node_modules/.*"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, ".*/\\w+\\..*\\.properties")};
    private static final String _PROPERTIES_FILE_NAME = "source-formatter.properties";
    private static final int _SUBREPOSITORY_MAX_DIR_LEVEL = 3;
    private List<String> _allFileNames;
    private int _maxStatusMessageLength = -1;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private boolean _portalSource;
    private final BlockingQueue<ProgressStatusUpdate> _progressStatusQueue = new LinkedBlockingQueue<ProgressStatusUpdate>();
    private final Thread _progressStatusThread = new Thread(){

        @Override
        public void run() {
            int fileScansCompletedCount = 0;
            int percentage = 0;
            int processedChecksFileCount = 0;
            int totalChecksFileCount = 0;
            boolean checksInitialized = false;
            while (true) {
                try {
                    while (true) {
                        ProgressStatusUpdate progressStatusUpdate;
                        ProgressStatus progressStatus;
                        if ((progressStatus = (progressStatusUpdate = (ProgressStatusUpdate)SourceFormatter.this._progressStatusQueue.take()).getProgressStatus()).equals((Object)ProgressStatus.CHECKS_INITIALIZED)) {
                            totalChecksFileCount += progressStatusUpdate.getCount();
                            if (++fileScansCompletedCount != SourceFormatter.this._sourceProcessors.size()) continue;
                            checksInitialized = true;
                            totalChecksFileCount -= processedChecksFileCount;
                            processedChecksFileCount = 0;
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.CHECK_FILE_COMPLETED)) {
                            ++processedChecksFileCount;
                            if (!checksInitialized) continue;
                            percentage = this._processCompletedPercentage(percentage, processedChecksFileCount, totalChecksFileCount);
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.SOURCE_FORMAT_COMPLETED)) break;
                    }
                    if (SourceFormatter.this._maxStatusMessageLength == -1) break;
                    StringBundler sb = new StringBundler(SourceFormatter.this._maxStatusMessageLength);
                    for (int i = 0; i < SourceFormatter.this._maxStatusMessageLength; ++i) {
                        sb.append(' ');
                    }
                    SourceFormatter.this._printProgressStatusMessage(sb.toString());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private int _processCompletedPercentage(int percentage, int count, int total) {
            int newPercentage = count * 100 / total;
            if (newPercentage > percentage) {
                SourceFormatter.this._printProgressStatusMessage("Processing checks: " + newPercentage + "% completed");
            }
            return newPercentage;
        }
    };
    private String _projectPathPrefix;
    private Map<String, Properties> _propertiesMap = new HashMap<String, Properties>();
    private final SourceFormatterArgs _sourceFormatterArgs;
    private SourceFormatterConfiguration _sourceFormatterConfiguration;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new ConcurrentSkipListSet<SourceFormatterMessage>();
    private SourceFormatterSuppressions _sourceFormatterSuppressions;
    private volatile List<SourceMismatchException> _sourceMismatchExceptions = new ArrayList<SourceMismatchException>();
    private List<SourceProcessor> _sourceProcessors = new ArrayList<SourceProcessor>();
    private boolean _subrepository;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            boolean autoFix = ArgumentsUtil.getBoolean(arguments, "source.auto.fix", true);
            sourceFormatterArgs.setAutoFix(autoFix);
            String baseDirName = ArgumentsUtil.getString(arguments, "source.base.dir", "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            String checkName = ArgumentsUtil.getString(arguments, "source.check.name", null);
            sourceFormatterArgs.setCheckName(checkName);
            boolean formatCurrentBranch = ArgumentsUtil.getBoolean(arguments, "format.current.branch", false);
            sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
            boolean formatLatestAuthor = ArgumentsUtil.getBoolean(arguments, "format.latest.author", false);
            sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
            boolean formatLocalChanges = ArgumentsUtil.getBoolean(arguments, "format.local.changes", false);
            sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
            if (formatCurrentBranch) {
                String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
                sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName, false));
            } else if (formatLatestAuthor) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName, false));
            } else if (formatLocalChanges) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName, false));
            }
            String fileNamesString = ArgumentsUtil.getString(arguments, "source.files", "");
            Object[] fileNames = StringUtil.split(fileNamesString, ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            } else {
                String fileExtensionsString = ArgumentsUtil.getString(arguments, "source.file.extensions", "");
                String[] fileExtensions = StringUtil.split(fileExtensionsString, ",");
                sourceFormatterArgs.setFileExtensions(Arrays.asList(fileExtensions));
            }
            boolean includeSubrepositories = ArgumentsUtil.getBoolean(arguments, "include.subrepositories", false);
            List<String> recentChangesFileNames = sourceFormatterArgs.getRecentChangesFileNames();
            if (recentChangesFileNames != null) {
                includeSubrepositories = true;
            }
            sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
            int maxLineLength = ArgumentsUtil.getInteger(arguments, "max.line.length", 80);
            sourceFormatterArgs.setMaxLineLength(maxLineLength);
            boolean printErrors = ArgumentsUtil.getBoolean(arguments, "source.print.errors", true);
            sourceFormatterArgs.setPrintErrors(printErrors);
            int processorThreadCount = ArgumentsUtil.getInteger(arguments, "processor.thread.count", 5);
            sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
            boolean showDebugInformation = ArgumentsUtil.getBoolean(arguments, "show.debug.information", false);
            sourceFormatterArgs.setShowDebugInformation(showDebugInformation);
            boolean showDocumentation = ArgumentsUtil.getBoolean(arguments, "show.documentation", false);
            sourceFormatterArgs.setShowDocumentation(showDocumentation);
            boolean showStatusUpdates = ArgumentsUtil.getBoolean(arguments, "show.status.updates", false);
            sourceFormatterArgs.setShowStatusUpdates(showStatusUpdates);
            boolean throwException = ArgumentsUtil.getBoolean(arguments, "source.throw.exception", false);
            sourceFormatterArgs.setThrowException(throwException);
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
        if (sourceFormatterArgs.isShowDocumentation()) {
            System.setProperty("java.awt.headless", "false");
        } else {
            System.setProperty("java.awt.headless", "true");
        }
    }

    public void format() throws Exception {
        this._printProgressStatusMessage("Scanning for files...");
        this._init();
        this._printProgressStatusMessage("Initializing checks...");
        this._progressStatusThread.setDaemon(true);
        this._progressStatusThread.setName("Source Formatter Progress Status Thread");
        this._progressStatusThread.start();
        this._sourceProcessors.add(new BNDSourceProcessor());
        this._sourceProcessors.add(new CodeownersSourceProcessor());
        this._sourceProcessors.add(new ConfigSourceProcessor());
        this._sourceProcessors.add(new CQLSourceProcessor());
        this._sourceProcessors.add(new CSSSourceProcessor());
        this._sourceProcessors.add(new DockerfileSourceProcessor());
        this._sourceProcessors.add(new DTDSourceProcessor());
        this._sourceProcessors.add(new LFRBuildSourceProcessor());
        this._sourceProcessors.add(new FTLSourceProcessor());
        this._sourceProcessors.add(new GradleSourceProcessor());
        this._sourceProcessors.add(new GroovySourceProcessor());
        this._sourceProcessors.add(new HTMLSourceProcessor());
        this._sourceProcessors.add(new JavaSourceProcessor());
        this._sourceProcessors.add(new JSONSourceProcessor());
        this._sourceProcessors.add(new JSPSourceProcessor());
        this._sourceProcessors.add(new JSSourceProcessor());
        this._sourceProcessors.add(new MarkdownSourceProcessor());
        this._sourceProcessors.add(new PackageinfoSourceProcessor());
        this._sourceProcessors.add(new PropertiesSourceProcessor());
        this._sourceProcessors.add(new SHSourceProcessor());
        this._sourceProcessors.add(new SoySourceProcessor());
        this._sourceProcessors.add(new SQLSourceProcessor());
        this._sourceProcessors.add(new TLDSourceProcessor());
        this._sourceProcessors.add(new TSSourceProcessor());
        this._sourceProcessors.add(new XMLSourceProcessor());
        this._sourceProcessors.add(new YMLSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(this._sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(this._sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : this._sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException ee1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                if (ee1 == null) {
                    ee1 = ee;
                    continue;
                }
                ee1.addSuppressed(ee);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.printSourceFormatterInformation();
        }
        this._progressStatusQueue.put(new ProgressStatusUpdate(ProgressStatus.SOURCE_FORMAT_COMPLETED));
        if (ee1 != null) {
            throw ee1;
        }
        if (!(!this._sourceFormatterArgs.isThrowException() || this._sourceFormatterMessages.isEmpty() && this._sourceMismatchExceptions.isEmpty())) {
            StringBundler stringBundler = new StringBundler((this._sourceFormatterMessages.size() + this._sourceMismatchExceptions.size()) * 4);
            int index = 1;
            if (!this._sourceFormatterMessages.isEmpty()) {
                for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
                    stringBundler.append(index);
                    stringBundler.append(": ");
                    stringBundler.append(sourceFormatterMessage.toString());
                    stringBundler.append("\n");
                    ++index;
                }
            }
            if (!this._sourceMismatchExceptions.isEmpty()) {
                for (SourceMismatchException sourceMismatchException : this._sourceMismatchExceptions) {
                    String message = sourceMismatchException.getMessage();
                    if (Objects.isNull(message)) continue;
                    stringBundler.append(index);
                    stringBundler.append(": ");
                    stringBundler.append(message);
                    stringBundler.append("\n");
                    ++index;
                }
            }
            String message = StringBundler.concat("Found ", String.valueOf(index - 1), " formatting issues:\n", stringBundler.toString());
            throw new Exception(message);
        }
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return this._sourceFormatterMessages;
    }

    public List<SourceMismatchException> getSourceMismatchExceptions() {
        return this._sourceMismatchExceptions;
    }

    private void _addDependentFileNames() {
        List<String> recentChangesFileNames = this._sourceFormatterArgs.getRecentChangesFileNames();
        if (recentChangesFileNames == null) {
            return;
        }
        HashSet<String> dependentFileNames = new HashSet<String>();
        block0: for (String recentChangesFileName : recentChangesFileNames) {
            if (!recentChangesFileName.endsWith("ServiceImpl.java")) continue;
            String dirName = recentChangesFileName.substring(0, recentChangesFileName.lastIndexOf(47));
            while (true) {
                String serviceFileName = dirName + "/service.xml";
                File file = new File(this._sourceFormatterArgs.getBaseDirName() + serviceFileName);
                if (file.exists()) {
                    dependentFileNames.add(serviceFileName);
                    continue block0;
                }
                int pos = dirName.lastIndexOf(47);
                if (pos == -1) continue block0;
                dirName = dirName.substring(0, pos);
            }
        }
        this._sourceFormatterArgs.addRecentChangesFileNames(dependentFileNames);
    }

    private void _excludeWorkingDirCheckoutPrivateApps() throws IOException {
        if (!this._isPortalSource()) {
            return;
        }
        File file = new File(this._getPortalDir(), "working.dir.properties");
        if (!file.exists()) {
            return;
        }
        Properties properties = this._getProperties(file);
        for (Object key : properties.keySet()) {
            String s = (String)key;
            if (!s.matches("working.dir.checkout.private.apps.(\\w)+.dirs")) continue;
            List<String> dirs = ListUtil.fromString(properties.getProperty(s), ",");
            for (String dir : dirs) {
                this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns("**/" + dir + "/**"));
            }
        }
    }

    private List<String> _getCheckNames() {
        ArrayList<String> checkNames = new ArrayList<String>();
        for (String sourceProcessorName : this._sourceFormatterConfiguration.getSourceProcessorNames()) {
            for (SourceCheckConfiguration sourceCheckConfiguration : this._sourceFormatterConfiguration.getSourceCheckConfigurations(sourceProcessorName)) {
                checkNames.add(sourceCheckConfiguration.getName());
            }
        }
        return checkNames;
    }

    private List<ExcludeSyntaxPattern> _getExcludeSyntaxPatterns(String sourceFormatterExcludes) {
        ArrayList<ExcludeSyntaxPattern> excludeSyntaxPatterns = new ArrayList<ExcludeSyntaxPattern>();
        List<String> excludes = ListUtil.fromString(sourceFormatterExcludes, ",");
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        String systemExcludes = System.getProperty("source.formatter.excludes");
        excludes = ListUtil.fromString(GetterUtil.getString(systemExcludes));
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        return excludeSyntaxPatterns;
    }

    private List<String> _getPluginsInsideModulesDirectoryNames() {
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/private/apps/**/build.xml"}, this._sourceFormatterExcludes, true);
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = SourceUtil.getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, '\\', '/'));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        return pluginsInsideModulesDirectoryNames;
    }

    private File _getPortalDir() {
        File portalImplDir = SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), "portal-impl", 7);
        if (portalImplDir == null) {
            return null;
        }
        return portalImplDir.getParentFile();
    }

    private String _getProjectPathPrefix() throws IOException {
        if (!this._subrepository) {
            return null;
        }
        String fileName = "gradle.properties";
        for (int i = 0; i < 7; ++i) {
            File file = new File(this._sourceFormatterArgs.getBaseDirName() + fileName);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                if (properties.containsKey("project.path.prefix")) {
                    return properties.getProperty("project.path.prefix");
                }
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    private Properties _getProperties(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            properties.load(new FileInputStream(file));
        }
        return properties;
    }

    private void _init() throws DocumentException, IOException {
        this._sourceFormatterExcludes = new SourceFormatterExcludes(SetUtil.fromArray(DEFAULT_EXCLUDE_SYNTAX_PATTERNS));
        this._excludeWorkingDirCheckoutPrivateApps();
        String parentDirName = this._sourceFormatterArgs.getBaseDirName();
        for (int i = 0; i < 7; ++i) {
            this._readProperties(new File(parentDirName + _PROPERTIES_FILE_NAME));
            parentDirName = parentDirName + "../";
        }
        this._allFileNames = SourceFormatterUtil.scanForFiles(this._sourceFormatterArgs.getBaseDirName(), new String[0], new String[]{"**/*.*", "**/CODEOWNERS", "**/Dockerfile", "**/packageinfo"}, this._sourceFormatterExcludes, this._sourceFormatterArgs.isIncludeSubrepositories());
        List<String> modulePropertiesFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties"}, this._sourceFormatterExcludes, true);
        for (String modulePropertiesFileName : modulePropertiesFileNames) {
            this._readProperties(new File(modulePropertiesFileName));
        }
        this._addDependentFileNames();
        this._pluginsInsideModulesDirectoryNames = this._getPluginsInsideModulesDirectoryNames();
        this._portalSource = this._isPortalSource();
        this._subrepository = this._isSubrepository();
        this._projectPathPrefix = this._getProjectPathPrefix();
        List<File> suppressionsFiles = SourceFormatterUtil.getSuppressionsFiles(this._sourceFormatterArgs.getBaseDirName(), this._allFileNames, this._sourceFormatterExcludes, "checkstyle-suppressions.xml", "source-formatter-suppressions.xml", "sourcechecks-suppressions.xml");
        this._sourceFormatterSuppressions = SuppressionsLoader.loadSuppressions(this._sourceFormatterArgs.getBaseDirName(), suppressionsFiles);
        this._sourceFormatterConfiguration = ConfigurationLoader.loadConfiguration("sourcechecks.xml");
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.SOURCE_CHECK, this._getCheckNames());
        }
    }

    private boolean _isPortalSource() {
        File portalImplDir = SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), "portal-impl", 7);
        return portalImplDir != null;
    }

    private boolean _isSubrepository() throws IOException {
        if (this._isPortalSource()) {
            return false;
        }
        String baseDirAbsolutePath = SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName());
        File baseDir = new File(baseDirAbsolutePath);
        for (int i = 0; i < 3; ++i) {
            String content;
            if (baseDir == null || !baseDir.exists()) {
                return false;
            }
            File gradlePropertiesFile = new File(baseDir, "gradle.properties");
            File gradlewFile = new File(baseDir, "gradlew");
            if (gradlePropertiesFile.exists() && gradlewFile.exists() && (content = FileUtil.read(gradlePropertiesFile)).contains("project.path.prefix=")) {
                return true;
            }
            baseDir = baseDir.getParentFile();
        }
        return false;
    }

    private void _printProgressStatusMessage(String message) {
        if (!this._sourceFormatterArgs.isShowStatusUpdates()) {
            return;
        }
        if (message.length() > this._maxStatusMessageLength) {
            this._maxStatusMessageLength = message.length();
        }
        System.out.print(message + "\r");
    }

    private void _readProperties(File propertiesFile) throws IOException {
        Properties properties = this._getProperties(propertiesFile);
        if (properties.isEmpty()) {
            return;
        }
        String propertiesFileLocation = SourceUtil.getAbsolutePath(propertiesFile);
        int pos = propertiesFileLocation.lastIndexOf("/");
        propertiesFileLocation = propertiesFileLocation.substring(0, pos + 1);
        String value = properties.getProperty("source.formatter.excludes");
        if (value == null) {
            this._propertiesMap.put(propertiesFileLocation, properties);
            return;
        }
        if (FileUtil.exists(propertiesFileLocation + "portal-impl")) {
            this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns(value));
        } else {
            this._sourceFormatterExcludes.addExcludeSyntaxPatterns(propertiesFileLocation, this._getExcludeSyntaxPatterns(value));
        }
        properties.remove("source.formatter.excludes");
        this._propertiesMap.put(propertiesFileLocation, properties);
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setAllFileNames(this._allFileNames);
        sourceProcessor.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceProcessor.setPortalSource(this._portalSource);
        sourceProcessor.setProgressStatusQueue(this._progressStatusQueue);
        sourceProcessor.setProjectPathPrefix(this._projectPathPrefix);
        sourceProcessor.setPropertiesMap(this._propertiesMap);
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.setSourceFormatterConfiguration(this._sourceFormatterConfiguration);
        sourceProcessor.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceProcessor.setSourceFormatterSuppressions(this._sourceFormatterSuppressions);
        sourceProcessor.setSubrepository(this._subrepository);
        sourceProcessor.format();
        this._sourceFormatterMessages.addAll(sourceProcessor.getSourceFormatterMessages());
        this._sourceMismatchExceptions.addAll(sourceProcessor.getSourceMismatchExceptions());
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
    }
}

