/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.GradleSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependenciesCheck
extends BaseFileCheck {
    private static final String _ORG_ECLIPSE_OSGI_3_13_0_LIFERAY_PATCHED_1 = "compileOnly group: \"com.liferay\", name: \"org.eclipse.osgi\", version: \"3.13.0.LIFERAY-PATCHED-1\"";
    private static final String _ORG_OSGI_CORE_6_0_0_DEPENDENCY = "compileOnly group: \"org.osgi\", name: \"org.osgi.core\", version: \"6.0.0\"";
    private static final String _OSGI_CORE_6_0_0_DEPENDENCY = "compileOnly group: \"org.osgi\", name: \"osgi.core\", version: \"6.0.0\"";
    private final Pattern _incorrectGroupNameVersionPattern = Pattern.compile("(^[^\\s]+)\\s+\"([^:]+?):([^:]+?):([^\"]+?)\"(.*?)", 32);
    private final Pattern _incorrectWhitespacePattern = Pattern.compile(":[^ \n]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> blocks = GradleSourceUtil.getDependenciesBlocks(content);
        for (String dependencies : blocks) {
            content = this._formatDependencies(content, dependencies);
        }
        return content;
    }

    private static boolean _hasPatchedOSGiCore(Set<String> dependencies) {
        if (!dependencies.contains(_ORG_ECLIPSE_OSGI_3_13_0_LIFERAY_PATCHED_1)) {
            return false;
        }
        return dependencies.contains(_OSGI_CORE_6_0_0_DEPENDENCY) || dependencies.contains(_ORG_OSGI_CORE_6_0_0_DEPENDENCY);
    }

    private String _formatDependencies(String content, String dependencies) {
        int y;
        String indent = SourceUtil.getIndent(dependencies);
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        Matcher matcher = this._incorrectWhitespacePattern.matcher(dependencies);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(dependencies, matcher.start())) continue;
            String newDependencies = StringUtil.insert(dependencies, " ", matcher.end() - 1);
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        if (dependencies.contains("'")) {
            String newDependencies = StringUtil.replace(dependencies, '\'', '\"');
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        TreeSet<String> uniqueDependencies = new TreeSet<String>(new GradleDependencyComparator());
        for (String dependency : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(dependency = dependency.trim())) continue;
            matcher = this._incorrectGroupNameVersionPattern.matcher(dependency);
            if (matcher.find()) {
                StringBundler sb = new StringBundler(9);
                sb.append(matcher.group(1));
                sb.append(" group: \"");
                sb.append(matcher.group(2));
                sb.append("\", name: \"");
                sb.append(matcher.group(3));
                sb.append("\", version: \"");
                sb.append(matcher.group(4));
                sb.append("\"");
                sb.append(matcher.group(5));
                dependency = sb.toString();
            }
            uniqueDependencies.add(dependency);
        }
        boolean patchedOSGiCore = GradleDependenciesCheck._hasPatchedOSGiCore(uniqueDependencies);
        if (patchedOSGiCore) {
            uniqueDependencies.remove(_ORG_OSGI_CORE_6_0_0_DEPENDENCY);
            uniqueDependencies.remove(_OSGI_CORE_6_0_0_DEPENDENCY);
        }
        StringBundler sb = new StringBundler();
        String previousConfiguration = null;
        for (String dependency : uniqueDependencies) {
            String configuration = GradleSourceUtil.getConfiguration(dependency);
            if (previousConfiguration == null || !previousConfiguration.equals(configuration)) {
                previousConfiguration = configuration;
                sb.append("\n");
                if (configuration.equals("compileOnly") && patchedOSGiCore) {
                    sb.append(indent);
                    sb.append("\t");
                    sb.append(_OSGI_CORE_6_0_0_DEPENDENCY);
                    sb.append("\n\n");
                }
            }
            sb.append(indent);
            sb.append("\t");
            sb.append(dependency);
            sb.append("\n");
        }
        return StringUtil.replace(content, dependencies, sb.toString());
    }

    private class GradleDependencyComparator
    implements Comparator<String>,
    Serializable {
        private GradleDependencyComparator() {
        }

        @Override
        public int compare(String dependency1, String dependency2) {
            String configuration2;
            String configuration1 = GradleSourceUtil.getConfiguration(dependency1);
            if (!configuration1.equals(configuration2 = GradleSourceUtil.getConfiguration(dependency2))) {
                return dependency1.compareTo(dependency2);
            }
            String group1 = this._getPropertyValue(dependency1, "group");
            String group2 = this._getPropertyValue(dependency2, "group");
            if (group1 != null && group1.equals(group2)) {
                int length2;
                int length1;
                String name1 = this._getPropertyValue(dependency1, "name");
                String name2 = this._getPropertyValue(dependency2, "name");
                if (name1 != null && name1.equals(name2) && (length1 = dependency1.length()) == (length2 = dependency2.length())) {
                    return 0;
                }
            }
            return dependency1.compareTo(dependency2);
        }

        private String _getPropertyValue(String dependency, String propertyName) {
            Pattern pattern = Pattern.compile(".* " + propertyName + ": \"(.+?)\"");
            Matcher matcher = pattern.matcher(dependency);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
    }
}

