/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDeprecatedJavadocCheck
extends BaseFileCheck {
    private static final Map<String, String> _releaseInfoMap = new HashMap<String, String>(){
        {
            this.put("Bunyan", "6.0.x");
            this.put("Judson", "7.1.x");
            this.put("Newton", "6.2.x");
            this.put("Paton", "6.1.x");
            this.put("Wilberforce", "7.0.x");
        }
    };
    private final Pattern _deprecatedPattern = Pattern.compile("(\n\\s*\\* @deprecated)( As of (([\\w.]+)(,? \\(([\\w.]+)\\))?)(.*?)\n\\s*\\*( @|/))?", 32);
    private String _nextReleaseCodeName;
    private String _nextReleaseVersion;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws ReflectiveOperationException {
        return this._formatDeprecatedJavadoc(content);
    }

    private String _formatDeprecatedJavadoc(String content) throws ReflectiveOperationException {
        Matcher matcher = this._deprecatedPattern.matcher(content);
        while (matcher.find()) {
            if (matcher.group(2) == null) {
                return StringUtil.insert(content, " As of " + this._getNextReleaseCodeName(), matcher.end(1));
            }
            String releaseCodeName = matcher.group(4);
            if (!_releaseInfoMap.containsKey(releaseCodeName)) {
                String nextReleaseCodeName = this._getNextReleaseCodeName();
                if (!releaseCodeName.equals(nextReleaseCodeName)) {
                    return StringUtil.replaceFirst(content, releaseCodeName, nextReleaseCodeName, matcher.start());
                }
                _releaseInfoMap.put(nextReleaseCodeName, this._getNextReleaseVersion());
            }
            String expectedReleaseVersion = _releaseInfoMap.get(releaseCodeName);
            if (matcher.group(5) == null) {
                return StringUtil.insert(content, StringBundler.concat(" (", expectedReleaseVersion, ")"), matcher.end(4));
            }
            if (StringUtil.startsWith(matcher.group(5), ",")) {
                String oldSub = matcher.group(5);
                return StringUtil.replaceFirst(content, oldSub, oldSub.substring(1), matcher.start(5));
            }
            String actualReleaseVersion = matcher.group(6);
            if (!actualReleaseVersion.equals(expectedReleaseVersion)) {
                return StringUtil.replaceFirst(content, actualReleaseVersion, expectedReleaseVersion, matcher.start(5));
            }
            String deprecatedInfo = matcher.group(7);
            if (Validator.isNull(deprecatedInfo)) continue;
            if (!deprecatedInfo.startsWith(",")) {
                return StringUtil.insert(content, ",", matcher.end(3));
            }
            if (!deprecatedInfo.startsWith(", ")) {
                return StringUtil.replaceFirst(content, ",", ", ", matcher.start(7));
            }
            if (deprecatedInfo.matches(", [A-Z].*")) {
                String s = deprecatedInfo.substring(0, 3);
                return StringUtil.replaceFirst(content, s, StringUtil.toLowerCase(s), matcher.start(7));
            }
            if (!deprecatedInfo.endsWith(".") || deprecatedInfo.matches("[\\S\\s]*\\.[ \n][\\S\\s]*")) continue;
            return StringUtil.replaceFirst(content, ".", "", matcher.end(7) - 1);
        }
        return content;
    }

    private synchronized String _getNextReleaseCodeName() throws ReflectiveOperationException {
        if (this._nextReleaseCodeName != null) {
            return this._nextReleaseCodeName;
        }
        Field codeNameField = ReleaseInfo.class.getDeclaredField("_CODE_NAME");
        codeNameField.setAccessible(true);
        this._nextReleaseCodeName = String.valueOf(codeNameField.get(null));
        return this._nextReleaseCodeName;
    }

    private synchronized String _getNextReleaseVersion() throws ReflectiveOperationException {
        if (this._nextReleaseVersion != null) {
            return this._nextReleaseVersion;
        }
        Field versionField = ReleaseInfo.class.getDeclaredField("_VERSION");
        versionField.setAccessible(true);
        this._nextReleaseVersion = StringUtil.replaceLast(String.valueOf(versionField.get(null)), ".0", ".x");
        return this._nextReleaseVersion;
    }
}

