/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.StringConcatenationCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class ConcatCheck
extends StringConcatenationCheck {
    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, "StringBundler", "concat");
        for (DetailAST methodCallAST : methodCallASTList) {
            this._checkConcatMethodCall(methodCallAST);
        }
    }

    private void _checkConcatMethodCall(DetailAST methodCallAST) {
        DetailAST elistAST = methodCallAST.findFirstToken(34);
        DetailAST previousLiteralStringAST = null;
        for (DetailAST childAST = elistAST.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (childAST.getType() != 28) continue;
            DetailAST grandChildAST = childAST.getFirstChild();
            if (grandChildAST.getType() != 139) {
                previousLiteralStringAST = null;
                continue;
            }
            if (previousLiteralStringAST != null) {
                this._checkConcatMethodCallLiteralStrings(previousLiteralStringAST, grandChildAST);
            }
            previousLiteralStringAST = grandChildAST;
        }
    }

    private void _checkConcatMethodCallLiteralStrings(DetailAST literalStringAST1, DetailAST literalStringAST2) {
        String literalStringValue1 = literalStringAST1.getText();
        literalStringValue1 = literalStringValue1.substring(1, literalStringValue1.length() - 1);
        String literalStringValue2 = literalStringAST2.getText();
        literalStringValue2 = literalStringValue2.substring(1, literalStringValue2.length() - 1);
        if (literalStringAST1.getLineNo() == literalStringAST2.getLineNo()) {
            if (!literalStringValue1.endsWith("\\n") || literalStringValue2.equals("\\n")) {
                this.log(literalStringAST1.getLineNo(), "literal.string.combine", new Object[]{literalStringValue1, literalStringValue2});
            }
            return;
        }
        this.checkLiteralStringStartAndEndCharacter(literalStringValue1, literalStringValue2, literalStringAST1.getLineNo());
        String line = this.getLine(literalStringAST1.getLineNo() - 1);
        int lineLength = CommonUtil.lengthExpandedTabs((String)line, (int)line.length(), (int)this.getTabWidth());
        int pos = this.getStringBreakPos(literalStringValue1, literalStringValue2, this.maxLineLength - lineLength);
        if (pos != -1) {
            this.log(literalStringAST2.getLineNo(), "literal.string.move", new Object[]{literalStringValue2.substring(0, pos + 1)});
        }
    }
}

