/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UnusedMethodCheck
extends BaseCheck {
    private static final String _MSG_UNUSED_METHOD = "method.unused";
    private String[] _allowedMethodNames = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void setAllowedMethodNames(String allowedMethodNames) {
        this._allowedMethodNames = ArrayUtil.append(this._allowedMethodNames, StringUtil.split(allowedMethodNames));
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        List<DetailAST> methodDefASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 9);
        if (methodDefASTList.isEmpty()) {
            return;
        }
        List<String> referencedMethodNames = this._getReferencedMethodNames(detailAST);
        for (DetailAST methodDefAST : methodDefASTList) {
            DetailAST nameAST;
            String name;
            DetailAST modifiersAST = methodDefAST.findFirstToken(5);
            if (!modifiersAST.branchContains(61) || this._hasSuppressUnusedWarningsAnnotation(methodDefAST) || ArrayUtil.contains(this._allowedMethodNames, name = (nameAST = methodDefAST.findFirstToken(58)).getText()) || referencedMethodNames.contains(nameAST.getText())) continue;
            this.log(methodDefAST.getLineNo(), _MSG_UNUSED_METHOD, new Object[]{name});
        }
    }

    private List<String> _getReferencedMethodNames(DetailAST classDefAST) {
        ArrayList<String> referencedMethodNames = new ArrayList<String>();
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(classDefAST, true, 27);
        for (DetailAST detailAST : methodCallASTList) {
            DetailAST nameAST = detailAST.getFirstChild();
            if (nameAST.getType() == 59) {
                nameAST = nameAST.getLastChild();
            }
            referencedMethodNames.add(nameAST.getText());
        }
        List<DetailAST> methodRefASTList = DetailASTUtil.getAllChildTokens(classDefAST, true, 180);
        for (DetailAST methodRefAST : methodRefASTList) {
            DetailAST lastChildAST = methodRefAST.getLastChild();
            referencedMethodNames.add(lastChildAST.getText());
        }
        List<DetailAST> list = DetailASTUtil.getAllChildTokens(classDefAST, true, 136);
        for (DetailAST literalNewAST : list) {
            DetailAST exprAST;
            DetailAST firstChildAST = literalNewAST.getFirstChild();
            if (firstChildAST == null || firstChildAST.getType() != 58 || !Objects.equals(firstChildAST.getText(), "MethodKey")) continue;
            DetailAST elist = literalNewAST.findFirstToken(34);
            List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elist, false, 28);
            if (exprASTList.size() < 2 || (firstChildAST = (exprAST = exprASTList.get(1)).getFirstChild()).getType() != 139) continue;
            String text = firstChildAST.getText();
            referencedMethodNames.add(text.substring(1, text.length() - 1));
        }
        return referencedMethodNames;
    }

    private boolean _hasSuppressUnusedWarningsAnnotation(DetailAST methodDefAST) {
        DetailAST annotationAST = AnnotationUtil.getAnnotation((DetailAST)methodDefAST, (String)"SuppressWarnings");
        if (annotationAST == null) {
            return false;
        }
        List<DetailAST> literalStringASTList = DetailASTUtil.getAllChildTokens(annotationAST, true, 139);
        for (DetailAST literalStringAST : literalStringASTList) {
            String s = literalStringAST.getText();
            if (!s.equals("\"unused\"")) continue;
            return true;
        }
        return false;
    }
}

