/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class BNDBundleCheck
extends BaseFileCheck {
    private static final String[] _REQUIRED_INSTRUCTIONS = new String[]{"Liferay-Releng-App-Description", "Liferay-Releng-App-Title", "Liferay-Releng-Bundle", "Liferay-Releng-Category", "Liferay-Releng-Demo-Url", "Liferay-Releng-Deprecated", "Liferay-Releng-Fix-Delivery-Method", "Liferay-Releng-Labs", "Liferay-Releng-Marketplace", "Liferay-Releng-Portal-Required", "Liferay-Releng-Public", "Liferay-Releng-Restart-Required", "Liferay-Releng-Support-Url", "Liferay-Releng-Supported"};
    private final List<String> _allowedFileNames = new ArrayList<String>();

    public void setAllowedFileNames(String allowedFileNames) {
        Collections.addAll(this._allowedFileNames, StringUtil.split(allowedFileNames));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        for (String allowedFileName : this._allowedFileNames) {
            if (!absolutePath.endsWith(allowedFileName)) continue;
            return content;
        }
        if (!content.matches("(?s).*Liferay-Releng-App-Title: " + Pattern.quote("${liferay.releng.app.title.prefix}") + " \\S+.*")) {
            String appTitle = this._getAppTitle(absolutePath);
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-App-Title", "${liferay.releng.app.title.prefix} " + appTitle);
        }
        if (content.matches("(?s).*Liferay-Releng-Deprecated:\\s*true.*")) {
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Bundle", "false");
        }
        content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Public", "${liferay.releng.public}");
        content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Restart-Required", "true");
        content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Support-Url", "http://www.liferay.com");
        content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Supported", "${liferay.releng.supported}");
        for (String instruction : _REQUIRED_INSTRUCTIONS) {
            if (content.contains(instruction + ":")) continue;
            content = StringBundler.concat(content, "\n", instruction, ":");
        }
        return content;
    }

    private String _getAppTitle(String absolutePath) {
        int pos = absolutePath.lastIndexOf("/");
        if (pos == -1) {
            return "";
        }
        String dirName = absolutePath.substring(0, pos);
        if ((pos = dirName.lastIndexOf("/")) == -1) {
            return "";
        }
        String shortDirName = dirName.substring(pos + 1);
        if (shortDirName.startsWith("com-liferay-")) {
            shortDirName = StringUtil.replaceFirst(shortDirName, "com-liferay-", "");
        }
        return TextFormatter.format(shortDirName, 9);
    }
}

